package io.fabric8.certmanager.api.model.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VaultAuthFluentImpl<A extends VaultAuthFluent<A>> extends BaseFluent<A> implements VaultAuthFluent<A>{
  public VaultAuthFluentImpl() {
  }
  public VaultAuthFluentImpl(VaultAuth instance) {
    this.withAppRole(instance.getAppRole()); 
    this.withKubernetes(instance.getKubernetes()); 
    this.withTokenSecretRef(instance.getTokenSecretRef()); 
  }
  private VaultAppRoleBuilder appRole;
  private VaultKubernetesAuthBuilder kubernetes;
  private SecretKeySelectorBuilder tokenSecretRef;
  
  /**
   * This method has been deprecated, please use method buildAppRole instead.
   * @return The buildable object.
   */
  @Deprecated
  public VaultAppRole getAppRole() {
    return this.appRole!=null ?this.appRole.build():null;
  }
  public VaultAppRole buildAppRole() {
    return this.appRole!=null ?this.appRole.build():null;
  }
  public A withAppRole(VaultAppRole appRole) {
    _visitables.get("appRole").remove(this.appRole);
    if (appRole!=null){ this.appRole= new VaultAppRoleBuilder(appRole); _visitables.get("appRole").add(this.appRole);} else { this.appRole = null; _visitables.get("appRole").remove(this.appRole); } return (A) this;
  }
  public Boolean hasAppRole() {
    return this.appRole != null;
  }
  public VaultAuthFluent.AppRoleNested<A> withNewAppRole() {
    return new VaultAuthFluentImpl.AppRoleNestedImpl();
  }
  public VaultAuthFluent.AppRoleNested<A> withNewAppRoleLike(VaultAppRole item) {
    return new VaultAuthFluentImpl.AppRoleNestedImpl(item);
  }
  public VaultAuthFluent.AppRoleNested<A> editAppRole() {
    return withNewAppRoleLike(getAppRole());
  }
  public VaultAuthFluent.AppRoleNested<A> editOrNewAppRole() {
    return withNewAppRoleLike(getAppRole() != null ? getAppRole(): new VaultAppRoleBuilder().build());
  }
  public VaultAuthFluent.AppRoleNested<A> editOrNewAppRoleLike(VaultAppRole item) {
    return withNewAppRoleLike(getAppRole() != null ? getAppRole(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubernetes instead.
   * @return The buildable object.
   */
  @Deprecated
  public VaultKubernetesAuth getKubernetes() {
    return this.kubernetes!=null ?this.kubernetes.build():null;
  }
  public VaultKubernetesAuth buildKubernetes() {
    return this.kubernetes!=null ?this.kubernetes.build():null;
  }
  public A withKubernetes(VaultKubernetesAuth kubernetes) {
    _visitables.get("kubernetes").remove(this.kubernetes);
    if (kubernetes!=null){ this.kubernetes= new VaultKubernetesAuthBuilder(kubernetes); _visitables.get("kubernetes").add(this.kubernetes);} else { this.kubernetes = null; _visitables.get("kubernetes").remove(this.kubernetes); } return (A) this;
  }
  public Boolean hasKubernetes() {
    return this.kubernetes != null;
  }
  public VaultAuthFluent.KubernetesNested<A> withNewKubernetes() {
    return new VaultAuthFluentImpl.KubernetesNestedImpl();
  }
  public VaultAuthFluent.KubernetesNested<A> withNewKubernetesLike(VaultKubernetesAuth item) {
    return new VaultAuthFluentImpl.KubernetesNestedImpl(item);
  }
  public VaultAuthFluent.KubernetesNested<A> editKubernetes() {
    return withNewKubernetesLike(getKubernetes());
  }
  public VaultAuthFluent.KubernetesNested<A> editOrNewKubernetes() {
    return withNewKubernetesLike(getKubernetes() != null ? getKubernetes(): new VaultKubernetesAuthBuilder().build());
  }
  public VaultAuthFluent.KubernetesNested<A> editOrNewKubernetesLike(VaultKubernetesAuth item) {
    return withNewKubernetesLike(getKubernetes() != null ? getKubernetes(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTokenSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getTokenSecretRef() {
    return this.tokenSecretRef!=null ?this.tokenSecretRef.build():null;
  }
  public SecretKeySelector buildTokenSecretRef() {
    return this.tokenSecretRef!=null ?this.tokenSecretRef.build():null;
  }
  public A withTokenSecretRef(SecretKeySelector tokenSecretRef) {
    _visitables.get("tokenSecretRef").remove(this.tokenSecretRef);
    if (tokenSecretRef!=null){ this.tokenSecretRef= new SecretKeySelectorBuilder(tokenSecretRef); _visitables.get("tokenSecretRef").add(this.tokenSecretRef);} else { this.tokenSecretRef = null; _visitables.get("tokenSecretRef").remove(this.tokenSecretRef); } return (A) this;
  }
  public Boolean hasTokenSecretRef() {
    return this.tokenSecretRef != null;
  }
  public A withNewTokenSecretRef(String key,String name) {
    return (A)withTokenSecretRef(new SecretKeySelector(key, name));
  }
  public VaultAuthFluent.TokenSecretRefNested<A> withNewTokenSecretRef() {
    return new VaultAuthFluentImpl.TokenSecretRefNestedImpl();
  }
  public VaultAuthFluent.TokenSecretRefNested<A> withNewTokenSecretRefLike(SecretKeySelector item) {
    return new VaultAuthFluentImpl.TokenSecretRefNestedImpl(item);
  }
  public VaultAuthFluent.TokenSecretRefNested<A> editTokenSecretRef() {
    return withNewTokenSecretRefLike(getTokenSecretRef());
  }
  public VaultAuthFluent.TokenSecretRefNested<A> editOrNewTokenSecretRef() {
    return withNewTokenSecretRefLike(getTokenSecretRef() != null ? getTokenSecretRef(): new SecretKeySelectorBuilder().build());
  }
  public VaultAuthFluent.TokenSecretRefNested<A> editOrNewTokenSecretRefLike(SecretKeySelector item) {
    return withNewTokenSecretRefLike(getTokenSecretRef() != null ? getTokenSecretRef(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VaultAuthFluentImpl that = (VaultAuthFluentImpl) o;
    if (appRole != null ? !appRole.equals(that.appRole) :that.appRole != null) return false;
    if (kubernetes != null ? !kubernetes.equals(that.kubernetes) :that.kubernetes != null) return false;
    if (tokenSecretRef != null ? !tokenSecretRef.equals(that.tokenSecretRef) :that.tokenSecretRef != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(appRole,  kubernetes,  tokenSecretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (appRole != null) { sb.append("appRole:"); sb.append(appRole + ","); }
    if (kubernetes != null) { sb.append("kubernetes:"); sb.append(kubernetes + ","); }
    if (tokenSecretRef != null) { sb.append("tokenSecretRef:"); sb.append(tokenSecretRef); }
    sb.append("}");
    return sb.toString();
  }
  class AppRoleNestedImpl<N> extends VaultAppRoleFluentImpl<VaultAuthFluent.AppRoleNested<N>> implements VaultAuthFluent.AppRoleNested<N>,Nested<N>{
    AppRoleNestedImpl(VaultAppRole item) {
      this.builder = new VaultAppRoleBuilder(this, item);
    }
    AppRoleNestedImpl() {
      this.builder = new VaultAppRoleBuilder(this);
    }
    VaultAppRoleBuilder builder;
    public N and() {
      return (N) VaultAuthFluentImpl.this.withAppRole(builder.build());
    }
    public N endAppRole() {
      return and();
    }
    
  }
  class KubernetesNestedImpl<N> extends VaultKubernetesAuthFluentImpl<VaultAuthFluent.KubernetesNested<N>> implements VaultAuthFluent.KubernetesNested<N>,Nested<N>{
    KubernetesNestedImpl(VaultKubernetesAuth item) {
      this.builder = new VaultKubernetesAuthBuilder(this, item);
    }
    KubernetesNestedImpl() {
      this.builder = new VaultKubernetesAuthBuilder(this);
    }
    VaultKubernetesAuthBuilder builder;
    public N and() {
      return (N) VaultAuthFluentImpl.this.withKubernetes(builder.build());
    }
    public N endKubernetes() {
      return and();
    }
    
  }
  class TokenSecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<VaultAuthFluent.TokenSecretRefNested<N>> implements VaultAuthFluent.TokenSecretRefNested<N>,Nested<N>{
    TokenSecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    TokenSecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) VaultAuthFluentImpl.this.withTokenSecretRef(builder.build());
    }
    public N endTokenSecretRef() {
      return and();
    }
    
  }
  
}