package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CAIssuerBuilder extends CAIssuerFluentImpl<CAIssuerBuilder> implements VisitableBuilder<CAIssuer,CAIssuerBuilder>{
  public CAIssuerBuilder() {
    this(false);
  }
  public CAIssuerBuilder(Boolean validationEnabled) {
    this(new CAIssuer(), validationEnabled);
  }
  public CAIssuerBuilder(CAIssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public CAIssuerBuilder(CAIssuerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CAIssuer(), validationEnabled);
  }
  public CAIssuerBuilder(CAIssuerFluent<?> fluent,CAIssuer instance) {
    this(fluent, instance, false);
  }
  public CAIssuerBuilder(CAIssuerFluent<?> fluent,CAIssuer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCrlDistributionPoints(instance.getCrlDistributionPoints()); 
    fluent.withOcspServers(instance.getOcspServers()); 
    fluent.withSecretName(instance.getSecretName()); 
    this.validationEnabled = validationEnabled; 
  }
  public CAIssuerBuilder(CAIssuer instance) {
    this(instance,false);
  }
  public CAIssuerBuilder(CAIssuer instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCrlDistributionPoints(instance.getCrlDistributionPoints()); 
    this.withOcspServers(instance.getOcspServers()); 
    this.withSecretName(instance.getSecretName()); 
    this.validationEnabled = validationEnabled; 
  }
  CAIssuerFluent<?> fluent;
  Boolean validationEnabled;
  public CAIssuer build() {
    CAIssuer buildable = new CAIssuer(fluent.getCrlDistributionPoints(),fluent.getOcspServers(),fluent.getSecretName());
    return buildable;
  }
  
}