/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.v1alpha2.CAIssuer;
import io.fabric8.certmanager.api.model.v1alpha2.CAIssuerFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CAIssuerFluentImpl<A extends CAIssuerFluent<A>>
extends BaseFluent<A>
implements CAIssuerFluent<A> {
    private List<String> crlDistributionPoints = new ArrayList<String>();
    private String secretName;

    public CAIssuerFluentImpl() {
    }

    public CAIssuerFluentImpl(CAIssuer instance) {
        this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        this.withSecretName(instance.getSecretName());
    }

    @Override
    public A addToCrlDistributionPoints(Integer index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCrlDistributionPoints(Integer index, String item) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCrlDistributionPoints(String ... items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCrlDistributionPoints(Collection<String> items) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.crlDistributionPoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCrlDistributionPoints(String ... items) {
        for (String item : items) {
            if (this.crlDistributionPoints == null) continue;
            this.crlDistributionPoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCrlDistributionPoints(Collection<String> items) {
        for (String item : items) {
            if (this.crlDistributionPoints == null) continue;
            this.crlDistributionPoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCrlDistributionPoints() {
        return this.crlDistributionPoints;
    }

    @Override
    public String getCrlDistributionPoint(Integer index) {
        return this.crlDistributionPoints.get(index);
    }

    @Override
    public String getFirstCrlDistributionPoint() {
        return this.crlDistributionPoints.get(0);
    }

    @Override
    public String getLastCrlDistributionPoint() {
        return this.crlDistributionPoints.get(this.crlDistributionPoints.size() - 1);
    }

    @Override
    public String getMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCrlDistributionPoint(Predicate<String> predicate) {
        for (String item : this.crlDistributionPoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCrlDistributionPoints(List<String> crlDistributionPoints) {
        if (crlDistributionPoints != null) {
            this.crlDistributionPoints = new ArrayList<String>();
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        } else {
            this.crlDistributionPoints = null;
        }
        return (A)this;
    }

    @Override
    public A withCrlDistributionPoints(String ... crlDistributionPoints) {
        if (this.crlDistributionPoints != null) {
            this.crlDistributionPoints.clear();
        }
        if (crlDistributionPoints != null) {
            for (String item : crlDistributionPoints) {
                this.addToCrlDistributionPoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCrlDistributionPoints() {
        return this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty();
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CAIssuerFluentImpl that = (CAIssuerFluentImpl)o;
        if (this.crlDistributionPoints != null ? !this.crlDistributionPoints.equals(that.crlDistributionPoints) : that.crlDistributionPoints != null) {
            return false;
        }
        return !(this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null);
    }

    public int hashCode() {
        return Objects.hash(this.crlDistributionPoints, this.secretName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.crlDistributionPoints != null && !this.crlDistributionPoints.isEmpty()) {
            sb.append("crlDistributionPoints:");
            sb.append(this.crlDistributionPoints + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName);
        }
        sb.append("}");
        return sb.toString();
    }
}

