package io.fabric8.certmanager.api.model.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateSpecFluentImpl<A extends CertificateSpecFluent<A>> extends BaseFluent<A> implements CertificateSpecFluent<A>{
  public CertificateSpecFluentImpl() {
  }
  public CertificateSpecFluentImpl(CertificateSpec instance) {
    this.withCommonName(instance.getCommonName()); 
    this.withDnsNames(instance.getDnsNames()); 
    this.withDuration(instance.getDuration()); 
    this.withEmailSANs(instance.getEmailSANs()); 
    this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest()); 
    this.withIpAddresses(instance.getIpAddresses()); 
    this.withIsCA(instance.getIsCA()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.withKeyAlgorithm(instance.getKeyAlgorithm()); 
    this.withKeyEncoding(instance.getKeyEncoding()); 
    this.withKeySize(instance.getKeySize()); 
    this.withKeystores(instance.getKeystores()); 
    this.withOrganization(instance.getOrganization()); 
    this.withPrivateKey(instance.getPrivateKey()); 
    this.withRenewBefore(instance.getRenewBefore()); 
    this.withSecretName(instance.getSecretName()); 
    this.withSubject(instance.getSubject()); 
    this.withUriSANs(instance.getUriSANs()); 
    this.withUsages(instance.getUsages()); 
  }
  private String commonName;
  private List<String> dnsNames = new ArrayList<String>();
  private Duration duration;
  private List<String> emailSANs = new ArrayList<String>();
  private Boolean encodeUsagesInRequest;
  private List<String> ipAddresses = new ArrayList<String>();
  private Boolean isCA;
  private ObjectReferenceBuilder issuerRef;
  private String keyAlgorithm;
  private String keyEncoding;
  private Integer keySize;
  private CertificateKeystoresBuilder keystores;
  private List<String> organization = new ArrayList<String>();
  private CertificatePrivateKeyBuilder privateKey;
  private Duration renewBefore;
  private String secretName;
  private X509SubjectBuilder subject;
  private List<String> uriSANs = new ArrayList<String>();
  private List<String> usages = new ArrayList<String>();
  public String getCommonName() {
    return this.commonName;
  }
  public A withCommonName(String commonName) {
    this.commonName=commonName; return (A) this;
  }
  public Boolean hasCommonName() {
    return this.commonName != null;
  }
  public A addToDnsNames(Integer index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.add(index, item);
    return (A)this;
  }
  public A setToDnsNames(Integer index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.set(index, item); return (A)this;
  }
  public A addToDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A addAllToDnsNames(Collection<String> items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A removeFromDnsNames(java.lang.String... items) {
    for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public A removeAllFromDnsNames(Collection<String> items) {
    for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public List<String> getDnsNames() {
    return this.dnsNames;
  }
  public String getDnsName(Integer index) {
    return this.dnsNames.get(index);
  }
  public String getFirstDnsName() {
    return this.dnsNames.get(0);
  }
  public String getLastDnsName() {
    return this.dnsNames.get(dnsNames.size() - 1);
  }
  public String getMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsNames(List<String> dnsNames) {
    if (dnsNames != null) {this.dnsNames = new ArrayList(); for (String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
  }
  public A withDnsNames(java.lang.String... dnsNames) {
    if (this.dnsNames != null) {this.dnsNames.clear();}
    if (dnsNames != null) {for (String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
  }
  public Boolean hasDnsNames() {
    return dnsNames != null && !dnsNames.isEmpty();
  }
  public Duration getDuration() {
    return this.duration;
  }
  public A withDuration(Duration duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public A addToEmailSANs(Integer index,String item) {
    if (this.emailSANs == null) {this.emailSANs = new ArrayList<String>();}
    this.emailSANs.add(index, item);
    return (A)this;
  }
  public A setToEmailSANs(Integer index,String item) {
    if (this.emailSANs == null) {this.emailSANs = new ArrayList<String>();}
    this.emailSANs.set(index, item); return (A)this;
  }
  public A addToEmailSANs(java.lang.String... items) {
    if (this.emailSANs == null) {this.emailSANs = new ArrayList<String>();}
    for (String item : items) {this.emailSANs.add(item);} return (A)this;
  }
  public A addAllToEmailSANs(Collection<String> items) {
    if (this.emailSANs == null) {this.emailSANs = new ArrayList<String>();}
    for (String item : items) {this.emailSANs.add(item);} return (A)this;
  }
  public A removeFromEmailSANs(java.lang.String... items) {
    for (String item : items) {if (this.emailSANs!= null){ this.emailSANs.remove(item);}} return (A)this;
  }
  public A removeAllFromEmailSANs(Collection<String> items) {
    for (String item : items) {if (this.emailSANs!= null){ this.emailSANs.remove(item);}} return (A)this;
  }
  public List<String> getEmailSANs() {
    return this.emailSANs;
  }
  public String getEmailSAN(Integer index) {
    return this.emailSANs.get(index);
  }
  public String getFirstEmailSAN() {
    return this.emailSANs.get(0);
  }
  public String getLastEmailSAN() {
    return this.emailSANs.get(emailSANs.size() - 1);
  }
  public String getMatchingEmailSAN(Predicate<String> predicate) {
    for (String item: emailSANs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEmailSAN(Predicate<String> predicate) {
    for (String item: emailSANs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEmailSANs(List<String> emailSANs) {
    if (emailSANs != null) {this.emailSANs = new ArrayList(); for (String item : emailSANs){this.addToEmailSANs(item);}} else { this.emailSANs = null;} return (A) this;
  }
  public A withEmailSANs(java.lang.String... emailSANs) {
    if (this.emailSANs != null) {this.emailSANs.clear();}
    if (emailSANs != null) {for (String item :emailSANs){ this.addToEmailSANs(item);}} return (A) this;
  }
  public Boolean hasEmailSANs() {
    return emailSANs != null && !emailSANs.isEmpty();
  }
  public Boolean getEncodeUsagesInRequest() {
    return this.encodeUsagesInRequest;
  }
  public A withEncodeUsagesInRequest(Boolean encodeUsagesInRequest) {
    this.encodeUsagesInRequest=encodeUsagesInRequest; return (A) this;
  }
  public Boolean hasEncodeUsagesInRequest() {
    return this.encodeUsagesInRequest != null;
  }
  public A addToIpAddresses(Integer index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.add(index, item);
    return (A)this;
  }
  public A setToIpAddresses(Integer index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.set(index, item); return (A)this;
  }
  public A addToIpAddresses(java.lang.String... items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A addAllToIpAddresses(Collection<String> items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A removeFromIpAddresses(java.lang.String... items) {
    for (String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
  }
  public A removeAllFromIpAddresses(Collection<String> items) {
    for (String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
  }
  public List<String> getIpAddresses() {
    return this.ipAddresses;
  }
  public String getIpAddress(Integer index) {
    return this.ipAddresses.get(index);
  }
  public String getFirstIpAddress() {
    return this.ipAddresses.get(0);
  }
  public String getLastIpAddress() {
    return this.ipAddresses.get(ipAddresses.size() - 1);
  }
  public String getMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpAddresses(List<String> ipAddresses) {
    if (ipAddresses != null) {this.ipAddresses = new ArrayList(); for (String item : ipAddresses){this.addToIpAddresses(item);}} else { this.ipAddresses = null;} return (A) this;
  }
  public A withIpAddresses(java.lang.String... ipAddresses) {
    if (this.ipAddresses != null) {this.ipAddresses.clear();}
    if (ipAddresses != null) {for (String item :ipAddresses){ this.addToIpAddresses(item);}} return (A) this;
  }
  public Boolean hasIpAddresses() {
    return ipAddresses != null && !ipAddresses.isEmpty();
  }
  public Boolean getIsCA() {
    return this.isCA;
  }
  public A withIsCA(Boolean isCA) {
    this.isCA=isCA; return (A) this;
  }
  public Boolean hasIsCA() {
    return this.isCA != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIssuerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public A withIssuerRef(ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} else { this.issuerRef = null; _visitables.get("issuerRef").remove(this.issuerRef); } return (A) this;
  }
  public Boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  public CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
    return new CertificateSpecFluentImpl.IssuerRefNestedImpl();
  }
  public CertificateSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new CertificateSpecFluentImpl.IssuerRefNestedImpl(item);
  }
  public CertificateSpecFluent.IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef());
  }
  public CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): new ObjectReferenceBuilder().build());
  }
  public CertificateSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): item);
  }
  public String getKeyAlgorithm() {
    return this.keyAlgorithm;
  }
  public A withKeyAlgorithm(String keyAlgorithm) {
    this.keyAlgorithm=keyAlgorithm; return (A) this;
  }
  public Boolean hasKeyAlgorithm() {
    return this.keyAlgorithm != null;
  }
  public String getKeyEncoding() {
    return this.keyEncoding;
  }
  public A withKeyEncoding(String keyEncoding) {
    this.keyEncoding=keyEncoding; return (A) this;
  }
  public Boolean hasKeyEncoding() {
    return this.keyEncoding != null;
  }
  public Integer getKeySize() {
    return this.keySize;
  }
  public A withKeySize(Integer keySize) {
    this.keySize=keySize; return (A) this;
  }
  public Boolean hasKeySize() {
    return this.keySize != null;
  }
  
  /**
   * This method has been deprecated, please use method buildKeystores instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificateKeystores getKeystores() {
    return this.keystores!=null ?this.keystores.build():null;
  }
  public CertificateKeystores buildKeystores() {
    return this.keystores!=null ?this.keystores.build():null;
  }
  public A withKeystores(CertificateKeystores keystores) {
    _visitables.get("keystores").remove(this.keystores);
    if (keystores!=null){ this.keystores= new CertificateKeystoresBuilder(keystores); _visitables.get("keystores").add(this.keystores);} else { this.keystores = null; _visitables.get("keystores").remove(this.keystores); } return (A) this;
  }
  public Boolean hasKeystores() {
    return this.keystores != null;
  }
  public CertificateSpecFluent.KeystoresNested<A> withNewKeystores() {
    return new CertificateSpecFluentImpl.KeystoresNestedImpl();
  }
  public CertificateSpecFluent.KeystoresNested<A> withNewKeystoresLike(CertificateKeystores item) {
    return new CertificateSpecFluentImpl.KeystoresNestedImpl(item);
  }
  public CertificateSpecFluent.KeystoresNested<A> editKeystores() {
    return withNewKeystoresLike(getKeystores());
  }
  public CertificateSpecFluent.KeystoresNested<A> editOrNewKeystores() {
    return withNewKeystoresLike(getKeystores() != null ? getKeystores(): new CertificateKeystoresBuilder().build());
  }
  public CertificateSpecFluent.KeystoresNested<A> editOrNewKeystoresLike(CertificateKeystores item) {
    return withNewKeystoresLike(getKeystores() != null ? getKeystores(): item);
  }
  public A addToOrganization(Integer index,String item) {
    if (this.organization == null) {this.organization = new ArrayList<String>();}
    this.organization.add(index, item);
    return (A)this;
  }
  public A setToOrganization(Integer index,String item) {
    if (this.organization == null) {this.organization = new ArrayList<String>();}
    this.organization.set(index, item); return (A)this;
  }
  public A addToOrganization(java.lang.String... items) {
    if (this.organization == null) {this.organization = new ArrayList<String>();}
    for (String item : items) {this.organization.add(item);} return (A)this;
  }
  public A addAllToOrganization(Collection<String> items) {
    if (this.organization == null) {this.organization = new ArrayList<String>();}
    for (String item : items) {this.organization.add(item);} return (A)this;
  }
  public A removeFromOrganization(java.lang.String... items) {
    for (String item : items) {if (this.organization!= null){ this.organization.remove(item);}} return (A)this;
  }
  public A removeAllFromOrganization(Collection<String> items) {
    for (String item : items) {if (this.organization!= null){ this.organization.remove(item);}} return (A)this;
  }
  public List<String> getOrganization() {
    return this.organization;
  }
  public String getOrganization(Integer index) {
    return this.organization.get(index);
  }
  public String getFirstOrganization() {
    return this.organization.get(0);
  }
  public String getLastOrganization() {
    return this.organization.get(organization.size() - 1);
  }
  public String getMatchingOrganization(Predicate<String> predicate) {
    for (String item: organization) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingOrganization(Predicate<String> predicate) {
    for (String item: organization) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOrganization(List<String> organization) {
    if (organization != null) {this.organization = new ArrayList(); for (String item : organization){this.addToOrganization(item);}} else { this.organization = null;} return (A) this;
  }
  public A withOrganization(java.lang.String... organization) {
    if (this.organization != null) {this.organization.clear();}
    if (organization != null) {for (String item :organization){ this.addToOrganization(item);}} return (A) this;
  }
  public Boolean hasOrganization() {
    return organization != null && !organization.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildPrivateKey instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificatePrivateKey getPrivateKey() {
    return this.privateKey!=null ?this.privateKey.build():null;
  }
  public CertificatePrivateKey buildPrivateKey() {
    return this.privateKey!=null ?this.privateKey.build():null;
  }
  public A withPrivateKey(CertificatePrivateKey privateKey) {
    _visitables.get("privateKey").remove(this.privateKey);
    if (privateKey!=null){ this.privateKey= new CertificatePrivateKeyBuilder(privateKey); _visitables.get("privateKey").add(this.privateKey);} else { this.privateKey = null; _visitables.get("privateKey").remove(this.privateKey); } return (A) this;
  }
  public Boolean hasPrivateKey() {
    return this.privateKey != null;
  }
  public A withNewPrivateKey(String rotationPolicy) {
    return (A)withPrivateKey(new CertificatePrivateKey(rotationPolicy));
  }
  public CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKey() {
    return new CertificateSpecFluentImpl.PrivateKeyNestedImpl();
  }
  public CertificateSpecFluent.PrivateKeyNested<A> withNewPrivateKeyLike(CertificatePrivateKey item) {
    return new CertificateSpecFluentImpl.PrivateKeyNestedImpl(item);
  }
  public CertificateSpecFluent.PrivateKeyNested<A> editPrivateKey() {
    return withNewPrivateKeyLike(getPrivateKey());
  }
  public CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKey() {
    return withNewPrivateKeyLike(getPrivateKey() != null ? getPrivateKey(): new CertificatePrivateKeyBuilder().build());
  }
  public CertificateSpecFluent.PrivateKeyNested<A> editOrNewPrivateKeyLike(CertificatePrivateKey item) {
    return withNewPrivateKeyLike(getPrivateKey() != null ? getPrivateKey(): item);
  }
  public Duration getRenewBefore() {
    return this.renewBefore;
  }
  public A withRenewBefore(Duration renewBefore) {
    this.renewBefore=renewBefore; return (A) this;
  }
  public Boolean hasRenewBefore() {
    return this.renewBefore != null;
  }
  public String getSecretName() {
    return this.secretName;
  }
  public A withSecretName(String secretName) {
    this.secretName=secretName; return (A) this;
  }
  public Boolean hasSecretName() {
    return this.secretName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSubject instead.
   * @return The buildable object.
   */
  @Deprecated
  public X509Subject getSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public X509Subject buildSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public A withSubject(X509Subject subject) {
    _visitables.get("subject").remove(this.subject);
    if (subject!=null){ this.subject= new X509SubjectBuilder(subject); _visitables.get("subject").add(this.subject);} else { this.subject = null; _visitables.get("subject").remove(this.subject); } return (A) this;
  }
  public Boolean hasSubject() {
    return this.subject != null;
  }
  public CertificateSpecFluent.SubjectNested<A> withNewSubject() {
    return new CertificateSpecFluentImpl.SubjectNestedImpl();
  }
  public CertificateSpecFluent.SubjectNested<A> withNewSubjectLike(X509Subject item) {
    return new CertificateSpecFluentImpl.SubjectNestedImpl(item);
  }
  public CertificateSpecFluent.SubjectNested<A> editSubject() {
    return withNewSubjectLike(getSubject());
  }
  public CertificateSpecFluent.SubjectNested<A> editOrNewSubject() {
    return withNewSubjectLike(getSubject() != null ? getSubject(): new X509SubjectBuilder().build());
  }
  public CertificateSpecFluent.SubjectNested<A> editOrNewSubjectLike(X509Subject item) {
    return withNewSubjectLike(getSubject() != null ? getSubject(): item);
  }
  public A addToUriSANs(Integer index,String item) {
    if (this.uriSANs == null) {this.uriSANs = new ArrayList<String>();}
    this.uriSANs.add(index, item);
    return (A)this;
  }
  public A setToUriSANs(Integer index,String item) {
    if (this.uriSANs == null) {this.uriSANs = new ArrayList<String>();}
    this.uriSANs.set(index, item); return (A)this;
  }
  public A addToUriSANs(java.lang.String... items) {
    if (this.uriSANs == null) {this.uriSANs = new ArrayList<String>();}
    for (String item : items) {this.uriSANs.add(item);} return (A)this;
  }
  public A addAllToUriSANs(Collection<String> items) {
    if (this.uriSANs == null) {this.uriSANs = new ArrayList<String>();}
    for (String item : items) {this.uriSANs.add(item);} return (A)this;
  }
  public A removeFromUriSANs(java.lang.String... items) {
    for (String item : items) {if (this.uriSANs!= null){ this.uriSANs.remove(item);}} return (A)this;
  }
  public A removeAllFromUriSANs(Collection<String> items) {
    for (String item : items) {if (this.uriSANs!= null){ this.uriSANs.remove(item);}} return (A)this;
  }
  public List<String> getUriSANs() {
    return this.uriSANs;
  }
  public String getUriSAN(Integer index) {
    return this.uriSANs.get(index);
  }
  public String getFirstUriSAN() {
    return this.uriSANs.get(0);
  }
  public String getLastUriSAN() {
    return this.uriSANs.get(uriSANs.size() - 1);
  }
  public String getMatchingUriSAN(Predicate<String> predicate) {
    for (String item: uriSANs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUriSAN(Predicate<String> predicate) {
    for (String item: uriSANs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUriSANs(List<String> uriSANs) {
    if (uriSANs != null) {this.uriSANs = new ArrayList(); for (String item : uriSANs){this.addToUriSANs(item);}} else { this.uriSANs = null;} return (A) this;
  }
  public A withUriSANs(java.lang.String... uriSANs) {
    if (this.uriSANs != null) {this.uriSANs.clear();}
    if (uriSANs != null) {for (String item :uriSANs){ this.addToUriSANs(item);}} return (A) this;
  }
  public Boolean hasUriSANs() {
    return uriSANs != null && !uriSANs.isEmpty();
  }
  public A addToUsages(Integer index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.add(index, item);
    return (A)this;
  }
  public A setToUsages(Integer index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.set(index, item); return (A)this;
  }
  public A addToUsages(java.lang.String... items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A addAllToUsages(Collection<String> items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A removeFromUsages(java.lang.String... items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public A removeAllFromUsages(Collection<String> items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public List<String> getUsages() {
    return this.usages;
  }
  public String getUsage(Integer index) {
    return this.usages.get(index);
  }
  public String getFirstUsage() {
    return this.usages.get(0);
  }
  public String getLastUsage() {
    return this.usages.get(usages.size() - 1);
  }
  public String getMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsages(List<String> usages) {
    if (usages != null) {this.usages = new ArrayList(); for (String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
  }
  public A withUsages(java.lang.String... usages) {
    if (this.usages != null) {this.usages.clear();}
    if (usages != null) {for (String item :usages){ this.addToUsages(item);}} return (A) this;
  }
  public Boolean hasUsages() {
    return usages != null && !usages.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CertificateSpecFluentImpl that = (CertificateSpecFluentImpl) o;
    if (commonName != null ? !commonName.equals(that.commonName) :that.commonName != null) return false;
    if (dnsNames != null ? !dnsNames.equals(that.dnsNames) :that.dnsNames != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (emailSANs != null ? !emailSANs.equals(that.emailSANs) :that.emailSANs != null) return false;
    if (encodeUsagesInRequest != null ? !encodeUsagesInRequest.equals(that.encodeUsagesInRequest) :that.encodeUsagesInRequest != null) return false;
    if (ipAddresses != null ? !ipAddresses.equals(that.ipAddresses) :that.ipAddresses != null) return false;
    if (isCA != null ? !isCA.equals(that.isCA) :that.isCA != null) return false;
    if (issuerRef != null ? !issuerRef.equals(that.issuerRef) :that.issuerRef != null) return false;
    if (keyAlgorithm != null ? !keyAlgorithm.equals(that.keyAlgorithm) :that.keyAlgorithm != null) return false;
    if (keyEncoding != null ? !keyEncoding.equals(that.keyEncoding) :that.keyEncoding != null) return false;
    if (keySize != null ? !keySize.equals(that.keySize) :that.keySize != null) return false;
    if (keystores != null ? !keystores.equals(that.keystores) :that.keystores != null) return false;
    if (organization != null ? !organization.equals(that.organization) :that.organization != null) return false;
    if (privateKey != null ? !privateKey.equals(that.privateKey) :that.privateKey != null) return false;
    if (renewBefore != null ? !renewBefore.equals(that.renewBefore) :that.renewBefore != null) return false;
    if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
    if (subject != null ? !subject.equals(that.subject) :that.subject != null) return false;
    if (uriSANs != null ? !uriSANs.equals(that.uriSANs) :that.uriSANs != null) return false;
    if (usages != null ? !usages.equals(that.usages) :that.usages != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(commonName,  dnsNames,  duration,  emailSANs,  encodeUsagesInRequest,  ipAddresses,  isCA,  issuerRef,  keyAlgorithm,  keyEncoding,  keySize,  keystores,  organization,  privateKey,  renewBefore,  secretName,  subject,  uriSANs,  usages,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (commonName != null) { sb.append("commonName:"); sb.append(commonName + ","); }
    if (dnsNames != null && !dnsNames.isEmpty()) { sb.append("dnsNames:"); sb.append(dnsNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (emailSANs != null && !emailSANs.isEmpty()) { sb.append("emailSANs:"); sb.append(emailSANs + ","); }
    if (encodeUsagesInRequest != null) { sb.append("encodeUsagesInRequest:"); sb.append(encodeUsagesInRequest + ","); }
    if (ipAddresses != null && !ipAddresses.isEmpty()) { sb.append("ipAddresses:"); sb.append(ipAddresses + ","); }
    if (isCA != null) { sb.append("isCA:"); sb.append(isCA + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (keyAlgorithm != null) { sb.append("keyAlgorithm:"); sb.append(keyAlgorithm + ","); }
    if (keyEncoding != null) { sb.append("keyEncoding:"); sb.append(keyEncoding + ","); }
    if (keySize != null) { sb.append("keySize:"); sb.append(keySize + ","); }
    if (keystores != null) { sb.append("keystores:"); sb.append(keystores + ","); }
    if (organization != null && !organization.isEmpty()) { sb.append("organization:"); sb.append(organization + ","); }
    if (privateKey != null) { sb.append("privateKey:"); sb.append(privateKey + ","); }
    if (renewBefore != null) { sb.append("renewBefore:"); sb.append(renewBefore + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (subject != null) { sb.append("subject:"); sb.append(subject + ","); }
    if (uriSANs != null && !uriSANs.isEmpty()) { sb.append("uriSANs:"); sb.append(uriSANs + ","); }
    if (usages != null && !usages.isEmpty()) { sb.append("usages:"); sb.append(usages); }
    sb.append("}");
    return sb.toString();
  }
  public A withEncodeUsagesInRequest() {
    return withEncodeUsagesInRequest(true);
  }
  public A withIsCA() {
    return withIsCA(true);
  }
  class IssuerRefNestedImpl<N> extends ObjectReferenceFluentImpl<CertificateSpecFluent.IssuerRefNested<N>> implements CertificateSpecFluent.IssuerRefNested<N>,Nested<N>{
    IssuerRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    IssuerRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withIssuerRef(builder.build());
    }
    public N endIssuerRef() {
      return and();
    }
    
  }
  class KeystoresNestedImpl<N> extends CertificateKeystoresFluentImpl<CertificateSpecFluent.KeystoresNested<N>> implements CertificateSpecFluent.KeystoresNested<N>,Nested<N>{
    KeystoresNestedImpl(CertificateKeystores item) {
      this.builder = new CertificateKeystoresBuilder(this, item);
    }
    KeystoresNestedImpl() {
      this.builder = new CertificateKeystoresBuilder(this);
    }
    CertificateKeystoresBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withKeystores(builder.build());
    }
    public N endKeystores() {
      return and();
    }
    
  }
  class PrivateKeyNestedImpl<N> extends CertificatePrivateKeyFluentImpl<CertificateSpecFluent.PrivateKeyNested<N>> implements CertificateSpecFluent.PrivateKeyNested<N>,Nested<N>{
    PrivateKeyNestedImpl(CertificatePrivateKey item) {
      this.builder = new CertificatePrivateKeyBuilder(this, item);
    }
    PrivateKeyNestedImpl() {
      this.builder = new CertificatePrivateKeyBuilder(this);
    }
    CertificatePrivateKeyBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withPrivateKey(builder.build());
    }
    public N endPrivateKey() {
      return and();
    }
    
  }
  class SubjectNestedImpl<N> extends X509SubjectFluentImpl<CertificateSpecFluent.SubjectNested<N>> implements CertificateSpecFluent.SubjectNested<N>,Nested<N>{
    SubjectNestedImpl(X509Subject item) {
      this.builder = new X509SubjectBuilder(this, item);
    }
    SubjectNestedImpl() {
      this.builder = new X509SubjectBuilder(this);
    }
    X509SubjectBuilder builder;
    public N and() {
      return (N) CertificateSpecFluentImpl.this.withSubject(builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}