package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateRequestSpecBuilder extends CertificateRequestSpecFluentImpl<CertificateRequestSpecBuilder> implements VisitableBuilder<CertificateRequestSpec,CertificateRequestSpecBuilder>{
  public CertificateRequestSpecBuilder() {
    this(false);
  }
  public CertificateRequestSpecBuilder(Boolean validationEnabled) {
    this(new CertificateRequestSpec(), validationEnabled);
  }
  public CertificateRequestSpecBuilder(CertificateRequestSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateRequestSpecBuilder(CertificateRequestSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateRequestSpec(), validationEnabled);
  }
  public CertificateRequestSpecBuilder(CertificateRequestSpecFluent<?> fluent,CertificateRequestSpec instance) {
    this(fluent, instance, false);
  }
  public CertificateRequestSpecBuilder(CertificateRequestSpecFluent<?> fluent,CertificateRequestSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCsr(instance.getCsr()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withIsCA(instance.getIsCA()); 
    fluent.withIssuerRef(instance.getIssuerRef()); 
    fluent.withUsages(instance.getUsages()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateRequestSpecBuilder(CertificateRequestSpec instance) {
    this(instance,false);
  }
  public CertificateRequestSpecBuilder(CertificateRequestSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCsr(instance.getCsr()); 
    this.withDuration(instance.getDuration()); 
    this.withIsCA(instance.getIsCA()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.withUsages(instance.getUsages()); 
    this.validationEnabled = validationEnabled; 
  }
  CertificateRequestSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateRequestSpec build() {
    CertificateRequestSpec buildable = new CertificateRequestSpec(fluent.getCsr(),fluent.getDuration(),fluent.getIsCA(),fluent.getIssuerRef(),fluent.getUsages());
    return buildable;
  }
  
}