package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VaultKubernetesAuthBuilder extends VaultKubernetesAuthFluentImpl<VaultKubernetesAuthBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth,io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthBuilder>{
  public VaultKubernetesAuthBuilder() {
    this(false);
  }
  public VaultKubernetesAuthBuilder(Boolean validationEnabled) {
    this(new VaultKubernetesAuth(), validationEnabled);
  }
  public VaultKubernetesAuthBuilder(VaultKubernetesAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public VaultKubernetesAuthBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VaultKubernetesAuth(), validationEnabled);
  }
  public VaultKubernetesAuthBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth instance) {
    this(fluent, instance, false);
  }
  public VaultKubernetesAuthBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMountPath(instance.getMountPath()); 
    fluent.withRole(instance.getRole()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public VaultKubernetesAuthBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth instance) {
    this(instance,false);
  }
  public VaultKubernetesAuthBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMountPath(instance.getMountPath()); 
    this.withRole(instance.getRole()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth build() {
    VaultKubernetesAuth buildable = new VaultKubernetesAuth(fluent.getMountPath(),fluent.getRole(),fluent.getSecretRef());
    return buildable;
  }
  
}