package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IssuerBuilder extends IssuerFluentImpl<IssuerBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha2.Issuer,IssuerBuilder>{
  public IssuerBuilder() {
    this(false);
  }
  public IssuerBuilder(Boolean validationEnabled) {
    this(new Issuer(), validationEnabled);
  }
  public IssuerBuilder(IssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public IssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.IssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Issuer(), validationEnabled);
  }
  public IssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.IssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.Issuer instance) {
    this(fluent, instance, false);
  }
  public IssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.IssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.Issuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public IssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.Issuer instance) {
    this(instance,false);
  }
  public IssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.Issuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1alpha2.IssuerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1alpha2.Issuer build() {
    Issuer buildable = new Issuer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}