package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateRequestSpecBuilder extends CertificateRequestSpecFluentImpl<CertificateRequestSpecBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpec,CertificateRequestSpecBuilder>{
  public CertificateRequestSpecBuilder() {
    this(false);
  }
  public CertificateRequestSpecBuilder(Boolean validationEnabled) {
    this(new CertificateRequestSpec(), validationEnabled);
  }
  public CertificateRequestSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateRequestSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CertificateRequestSpec(), validationEnabled);
  }
  public CertificateRequestSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpecFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpec instance) {
    this(fluent, instance, false);
  }
  public CertificateRequestSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpecFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCsr(instance.getCsr()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withIsCA(instance.getIsCA()); 
    fluent.withIssuerRef(instance.getIssuerRef()); 
    fluent.withUsages(instance.getUsages()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateRequestSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpec instance) {
    this(instance,false);
  }
  public CertificateRequestSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCsr(instance.getCsr()); 
    this.withDuration(instance.getDuration()); 
    this.withIsCA(instance.getIsCA()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.withUsages(instance.getUsages()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpec build() {
    CertificateRequestSpec buildable = new CertificateRequestSpec(fluent.getCsr(),fluent.getDuration(),fluent.getIsCA(),fluent.getIssuerRef(),fluent.getUsages());
    return buildable;
  }
  
}