package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateDNSNameSelectorBuilder extends CertificateDNSNameSelectorFluentImpl<CertificateDNSNameSelectorBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelector,CertificateDNSNameSelectorBuilder>{
  public CertificateDNSNameSelectorBuilder() {
    this(false);
  }
  public CertificateDNSNameSelectorBuilder(Boolean validationEnabled) {
    this(new CertificateDNSNameSelector(), validationEnabled);
  }
  public CertificateDNSNameSelectorBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateDNSNameSelectorBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CertificateDNSNameSelector(), validationEnabled);
  }
  public CertificateDNSNameSelectorBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelectorFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelector instance) {
    this(fluent, instance, false);
  }
  public CertificateDNSNameSelectorBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelectorFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDnsNames(instance.getDnsNames()); 
    fluent.withDnsZones(instance.getDnsZones()); 
    fluent.withMatchLabels(instance.getMatchLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateDNSNameSelectorBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelector instance) {
    this(instance,false);
  }
  public CertificateDNSNameSelectorBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDnsNames(instance.getDnsNames()); 
    this.withDnsZones(instance.getDnsZones()); 
    this.withMatchLabels(instance.getMatchLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.acme.v1alpha2.CertificateDNSNameSelector build() {
    CertificateDNSNameSelector buildable = new CertificateDNSNameSelector(fluent.getDnsNames(),fluent.getDnsZones(),fluent.getMatchLabels());
    return buildable;
  }
  
}