package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEIssuerStatusBuilder extends ACMEIssuerStatusFluentImpl<ACMEIssuerStatusBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatus,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatusBuilder>{
  public ACMEIssuerStatusBuilder() {
    this(false);
  }
  public ACMEIssuerStatusBuilder(Boolean validationEnabled) {
    this(new ACMEIssuerStatus(), validationEnabled);
  }
  public ACMEIssuerStatusBuilder(ACMEIssuerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEIssuerStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ACMEIssuerStatus(), validationEnabled);
  }
  public ACMEIssuerStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatusFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatus instance) {
    this(fluent, instance, false);
  }
  public ACMEIssuerStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatusFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastRegisteredEmail(instance.getLastRegisteredEmail()); 
    fluent.withUri(instance.getUri()); 
    this.validationEnabled = validationEnabled; 
  }
  public ACMEIssuerStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatus instance) {
    this(instance,false);
  }
  public ACMEIssuerStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastRegisteredEmail(instance.getLastRegisteredEmail()); 
    this.withUri(instance.getUri()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEIssuerStatus build() {
    ACMEIssuerStatus buildable = new ACMEIssuerStatus(fluent.getLastRegisteredEmail(),fluent.getUri());
    return buildable;
  }
  
}