/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.v1alpha2.Issuer;
import io.fabric8.certmanager.api.model.v1alpha2.IssuerFluent;
import io.fabric8.certmanager.api.model.v1alpha2.IssuerFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class IssuerBuilder
extends IssuerFluentImpl<IssuerBuilder>
implements VisitableBuilder<Issuer, IssuerBuilder> {
    IssuerFluent<?> fluent;
    Boolean validationEnabled;

    public IssuerBuilder() {
        this(false);
    }

    public IssuerBuilder(Boolean validationEnabled) {
        this(new Issuer(), validationEnabled);
    }

    public IssuerBuilder(IssuerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IssuerBuilder(IssuerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Issuer(), validationEnabled);
    }

    public IssuerBuilder(IssuerFluent<?> fluent, Issuer instance) {
        this(fluent, instance, false);
    }

    public IssuerBuilder(IssuerFluent<?> fluent, Issuer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public IssuerBuilder(Issuer instance) {
        this(instance, (Boolean)false);
    }

    public IssuerBuilder(Issuer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public Issuer build() {
        Issuer buildable = new Issuer(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IssuerBuilder that = (IssuerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

