/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpec;
import io.fabric8.certmanager.api.model.v1alpha2.CertificateRequestSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CertificateRequestSpecFluentImpl<A extends CertificateRequestSpecFluent<A>>
extends BaseFluent<A>
implements CertificateRequestSpecFluent<A> {
    private List<Integer> csr;
    private Duration duration;
    private Boolean isCA;
    private ObjectReferenceBuilder issuerRef;
    private List<String> usages;

    public CertificateRequestSpecFluentImpl() {
    }

    public CertificateRequestSpecFluentImpl(CertificateRequestSpec instance) {
        this.withCsr(instance.getCsr());
        this.withDuration(instance.getDuration());
        this.withIsCA(instance.getIsCA());
        this.withIssuerRef(instance.getIssuerRef());
        this.withUsages(instance.getUsages());
    }

    @Override
    public A addToCsr(int index, Integer item) {
        if (this.csr == null) {
            this.csr = new ArrayList<Integer>();
        }
        this.csr.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCsr(int index, Integer item) {
        if (this.csr == null) {
            this.csr = new ArrayList<Integer>();
        }
        this.csr.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCsr(Integer ... items) {
        if (this.csr == null) {
            this.csr = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.csr.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCsr(Collection<Integer> items) {
        if (this.csr == null) {
            this.csr = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.csr.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCsr(Integer ... items) {
        for (Integer item : items) {
            if (this.csr == null) continue;
            this.csr.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCsr(Collection<Integer> items) {
        for (Integer item : items) {
            if (this.csr == null) continue;
            this.csr.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Integer> getCsr() {
        return this.csr;
    }

    @Override
    public Integer getCsr(int index) {
        return this.csr.get(index);
    }

    @Override
    public Integer getFirstCsr() {
        return this.csr.get(0);
    }

    @Override
    public Integer getLastCsr() {
        return this.csr.get(this.csr.size() - 1);
    }

    @Override
    public Integer getMatchingCsr(Predicate<Integer> predicate) {
        for (Integer item : this.csr) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCsr(Predicate<Integer> predicate) {
        for (Integer item : this.csr) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCsr(List<Integer> csr) {
        if (this.csr != null) {
            this._visitables.get((Object)"csr").removeAll(this.csr);
        }
        if (csr != null) {
            this.csr = new ArrayList<Integer>();
            for (Integer item : csr) {
                this.addToCsr(item);
            }
        } else {
            this.csr = null;
        }
        return (A)this;
    }

    @Override
    public A withCsr(Integer ... csr) {
        if (this.csr != null) {
            this.csr.clear();
        }
        if (csr != null) {
            for (Integer item : csr) {
                this.addToCsr(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCsr() {
        return this.csr != null && !this.csr.isEmpty();
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(Duration duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public Boolean getIsCA() {
        return this.isCA;
    }

    @Override
    public A withIsCA(Boolean isCA) {
        this.isCA = isCA;
        return (A)this;
    }

    @Override
    public Boolean hasIsCA() {
        return this.isCA != null;
    }

    @Override
    @Deprecated
    public ObjectReference getIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    @Override
    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.get((Object)"issuerRef").remove(this.issuerRef);
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    @Override
    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNestedImpl();
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNestedImpl(item);
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef());
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public CertificateRequestSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(this.getIssuerRef() != null ? this.getIssuerRef() : item);
    }

    @Override
    public A addToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsages(String ... items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsages(Collection<String> items) {
        for (String item : items) {
            if (this.usages == null) continue;
            this.usages.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsages() {
        return this.usages;
    }

    @Override
    public String getUsage(int index) {
        return this.usages.get(index);
    }

    @Override
    public String getFirstUsage() {
        return this.usages.get(0);
    }

    @Override
    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    @Override
    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUsages(List<String> usages) {
        if (this.usages != null) {
            this._visitables.get((Object)"usages").removeAll(this.usages);
        }
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)this;
    }

    @Override
    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    @Override
    public A addNewUsage(String arg0) {
        return this.addToUsages(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateRequestSpecFluentImpl that = (CertificateRequestSpecFluentImpl)o;
        if (this.csr != null ? !this.csr.equals(that.csr) : that.csr != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals((Object)that.duration) : that.duration != null) {
            return false;
        }
        if (this.isCA != null ? !this.isCA.equals(that.isCA) : that.isCA != null) {
            return false;
        }
        if (this.issuerRef != null ? !this.issuerRef.equals(that.issuerRef) : that.issuerRef != null) {
            return false;
        }
        return !(this.usages != null ? !this.usages.equals(that.usages) : that.usages != null);
    }

    public int hashCode() {
        return Objects.hash(this.csr, this.duration, this.isCA, this.issuerRef, this.usages, super.hashCode());
    }

    public class IssuerRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<CertificateRequestSpecFluent.IssuerRefNested<N>>
    implements CertificateRequestSpecFluent.IssuerRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        IssuerRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        IssuerRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CertificateRequestSpecFluentImpl.this.withIssuerRef(this.builder.build());
        }

        @Override
        public N endIssuerRef() {
            return this.and();
        }
    }
}

