package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

public class VaultAppRoleFluentImpl<A extends io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent<A> {

    private java.lang.String path;
    private java.lang.String roleId;
    private io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder secretRef;

    public VaultAppRoleFluentImpl() {
    }

    public VaultAppRoleFluentImpl(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole instance) {
        this.withPath(instance.getPath()); 
        this.withRoleId(instance.getRoleId()); 
        this.withSecretRef(instance.getSecretRef()); 
    }

    public java.lang.String getPath() {
        return this.path;
    }

    public A withPath(java.lang.String path) {
        this.path=path; return (A) this;
    }

    public java.lang.Boolean hasPath() {
        return this.path != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPath instead.
     */
        public A withNewPath(java.lang.String arg0) {
        return (A)withPath(new String(arg0));
    }

    public java.lang.String getRoleId() {
        return this.roleId;
    }

    public A withRoleId(java.lang.String roleId) {
        this.roleId=roleId; return (A) this;
    }

    public java.lang.Boolean hasRoleId() {
        return this.roleId != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withRoleId instead.
     */
        public A withNewRoleId(java.lang.String arg0) {
        return (A)withRoleId(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSecretRef instead.
     * @return The buildable object.
     */
        public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector getSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector buildSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector secretRef) {
        _visitables.get("secretRef").remove(this.secretRef);
        if (secretRef!=null){ this.secretRef= new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
    }

    public java.lang.Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(java.lang.String key,java.lang.String name) {
        return (A)withSecretRef(new SecretKeySelector(key, name));
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent.SecretRefNested<A> withNewSecretRef() {
        return new io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluentImpl.SecretRefNestedImpl();
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent.SecretRefNested<A> withNewSecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
        return new io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluentImpl.SecretRefNestedImpl(item);
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent.SecretRefNested<A> editSecretRef() {
        return withNewSecretRefLike(getSecretRef());
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent.SecretRefNested<A> editOrNewSecretRef() {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder().build());
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent.SecretRefNested<A> editOrNewSecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VaultAppRoleFluentImpl that = (VaultAppRoleFluentImpl) o;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (roleId != null ? !roleId.equals(that.roleId) :that.roleId != null) return false;
        if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(path,  roleId,  secretRef,  super.hashCode());
    }

    public class SecretRefNestedImpl<N> extends io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl<io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent.SecretRefNested<N>> implements io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent.SecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder builder;

            SecretRefNestedImpl(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this, item);
                        
            }

            SecretRefNestedImpl() {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this);
                        
            }

            public N and() {
                return (N) VaultAppRoleFluentImpl.this.withSecretRef(builder.build());
            }

            public N endSecretRef() {
                return and();
            }
    }


}
