/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.v1alpha2.VaultAuth;
import io.fabric8.certmanager.api.model.v1alpha2.VaultAuthBuilder;
import io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluentImpl;
import io.fabric8.certmanager.api.model.v1alpha2.VaultIssuer;
import io.fabric8.certmanager.api.model.v1alpha2.VaultIssuerFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class VaultIssuerFluentImpl<A extends VaultIssuerFluent<A>>
extends BaseFluent<A>
implements VaultIssuerFluent<A> {
    private VaultAuthBuilder auth;
    private List<Integer> caBundle;
    private String namespace;
    private String path;
    private String server;

    public VaultIssuerFluentImpl() {
    }

    public VaultIssuerFluentImpl(VaultIssuer instance) {
        this.withAuth(instance.getAuth());
        this.withCaBundle(instance.getCaBundle());
        this.withNamespace(instance.getNamespace());
        this.withPath(instance.getPath());
        this.withServer(instance.getServer());
    }

    @Override
    @Deprecated
    public VaultAuth getAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    @Override
    public VaultAuth buildAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    @Override
    public A withAuth(VaultAuth auth) {
        this._visitables.get((Object)"auth").remove(this.auth);
        if (auth != null) {
            this.auth = new VaultAuthBuilder(auth);
            this._visitables.get((Object)"auth").add(this.auth);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuth() {
        return this.auth != null;
    }

    @Override
    public VaultIssuerFluent.AuthNested<A> withNewAuth() {
        return new AuthNestedImpl();
    }

    @Override
    public VaultIssuerFluent.AuthNested<A> withNewAuthLike(VaultAuth item) {
        return new AuthNestedImpl(item);
    }

    @Override
    public VaultIssuerFluent.AuthNested<A> editAuth() {
        return this.withNewAuthLike(this.getAuth());
    }

    @Override
    public VaultIssuerFluent.AuthNested<A> editOrNewAuth() {
        return this.withNewAuthLike(this.getAuth() != null ? this.getAuth() : new VaultAuthBuilder().build());
    }

    @Override
    public VaultIssuerFluent.AuthNested<A> editOrNewAuthLike(VaultAuth item) {
        return this.withNewAuthLike(this.getAuth() != null ? this.getAuth() : item);
    }

    @Override
    public A addToCaBundle(int index, Integer item) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Integer>();
        }
        this.caBundle.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCaBundle(int index, Integer item) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Integer>();
        }
        this.caBundle.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCaBundle(Integer ... items) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCaBundle(Collection<Integer> items) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Integer>();
        }
        for (Integer item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCaBundle(Integer ... items) {
        for (Integer item : items) {
            if (this.caBundle == null) continue;
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCaBundle(Collection<Integer> items) {
        for (Integer item : items) {
            if (this.caBundle == null) continue;
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Integer> getCaBundle() {
        return this.caBundle;
    }

    @Override
    public Integer getCaBundle(int index) {
        return this.caBundle.get(index);
    }

    @Override
    public Integer getFirstCaBundle() {
        return this.caBundle.get(0);
    }

    @Override
    public Integer getLastCaBundle() {
        return this.caBundle.get(this.caBundle.size() - 1);
    }

    @Override
    public Integer getMatchingCaBundle(Predicate<Integer> predicate) {
        for (Integer item : this.caBundle) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCaBundle(Predicate<Integer> predicate) {
        for (Integer item : this.caBundle) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCaBundle(List<Integer> caBundle) {
        if (this.caBundle != null) {
            this._visitables.get((Object)"caBundle").removeAll(this.caBundle);
        }
        if (caBundle != null) {
            this.caBundle = new ArrayList<Integer>();
            for (Integer item : caBundle) {
                this.addToCaBundle(item);
            }
        } else {
            this.caBundle = null;
        }
        return (A)this;
    }

    @Override
    public A withCaBundle(Integer ... caBundle) {
        if (this.caBundle != null) {
            this.caBundle.clear();
        }
        if (caBundle != null) {
            for (Integer item : caBundle) {
                this.addToCaBundle(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCaBundle() {
        return this.caBundle != null && !this.caBundle.isEmpty();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    @Deprecated
    public A withNewNamespace(String arg0) {
        return this.withNamespace(new String(arg0));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public A withNewPath(String arg0) {
        return this.withPath(new String(arg0));
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public A withServer(String server) {
        this.server = server;
        return (A)this;
    }

    @Override
    public Boolean hasServer() {
        return this.server != null;
    }

    @Override
    @Deprecated
    public A withNewServer(String arg0) {
        return this.withServer(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultIssuerFluentImpl that = (VaultIssuerFluentImpl)o;
        if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) {
            return false;
        }
        if (this.caBundle != null ? !this.caBundle.equals(that.caBundle) : that.caBundle != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return !(this.server != null ? !this.server.equals(that.server) : that.server != null);
    }

    public int hashCode() {
        return Objects.hash(this.auth, this.caBundle, this.namespace, this.path, this.server, super.hashCode());
    }

    public class AuthNestedImpl<N>
    extends VaultAuthFluentImpl<VaultIssuerFluent.AuthNested<N>>
    implements VaultIssuerFluent.AuthNested<N>,
    Nested<N> {
        private final VaultAuthBuilder builder;

        AuthNestedImpl(VaultAuth item) {
            this.builder = new VaultAuthBuilder(this, item);
        }

        AuthNestedImpl() {
            this.builder = new VaultAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultIssuerFluentImpl.this.withAuth(this.builder.build());
        }

        @Override
        public N endAuth() {
            return this.and();
        }
    }
}

