package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VaultAppRoleBuilder extends io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluentImpl<io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole,io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleBuilder> {

    io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public VaultAppRoleBuilder() {
        this(true);
    }

    public VaultAppRoleBuilder(java.lang.Boolean validationEnabled) {
        this(new VaultAppRole(), validationEnabled);
    }

    public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent<?> fluent) {
        this(fluent, true);
    }

    public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new VaultAppRole(), validationEnabled);
    }

    public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole instance) {
        this(fluent, instance, true);
    }

    public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPath(instance.getPath()); 
        fluent.withRoleId(instance.getRoleId()); 
        fluent.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole instance) {
        this(instance,true);
    }

    public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPath(instance.getPath()); 
        this.withRoleId(instance.getRoleId()); 
        this.withSecretRef(instance.getSecretRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.certmanager.api.model.v1alpha2.EditableVaultAppRole build() {
        EditableVaultAppRole buildable = new EditableVaultAppRole(fluent.getPath(),fluent.getRoleId(),fluent.getSecretRef());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VaultAppRoleBuilder that = (VaultAppRoleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
