package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CAIssuerBuilder extends io.fabric8.certmanager.api.model.v1alpha2.CAIssuerFluentImpl<io.fabric8.certmanager.api.model.v1alpha2.CAIssuerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha2.CAIssuer,io.fabric8.certmanager.api.model.v1alpha2.CAIssuerBuilder> {

    io.fabric8.certmanager.api.model.v1alpha2.CAIssuerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CAIssuerBuilder() {
        this(true);
    }

    public CAIssuerBuilder(java.lang.Boolean validationEnabled) {
        this(new CAIssuer(), validationEnabled);
    }

    public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.CAIssuerFluent<?> fluent) {
        this(fluent, true);
    }

    public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.CAIssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CAIssuer(), validationEnabled);
    }

    public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.CAIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.CAIssuer instance) {
        this(fluent, instance, true);
    }

    public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.CAIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.CAIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCrlDistributionPoints(instance.getCrlDistributionPoints()); 
        fluent.withSecretName(instance.getSecretName()); 
        this.validationEnabled = validationEnabled; 
    }

    public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.CAIssuer instance) {
        this(instance,true);
    }

    public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.CAIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCrlDistributionPoints(instance.getCrlDistributionPoints()); 
        this.withSecretName(instance.getSecretName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.certmanager.api.model.v1alpha2.EditableCAIssuer build() {
        EditableCAIssuer buildable = new EditableCAIssuer(fluent.getCrlDistributionPoints(),fluent.getSecretName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CAIssuerBuilder that = (CAIssuerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
