/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.v1alpha2.Issuer;
import io.fabric8.certmanager.api.model.v1alpha2.IssuerBuilder;
import io.fabric8.certmanager.api.model.v1alpha2.IssuerFluentImpl;
import io.fabric8.certmanager.api.model.v1alpha2.IssuerList;
import io.fabric8.certmanager.api.model.v1alpha2.IssuerListFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IssuerListFluentImpl<A extends IssuerListFluent<A>>
extends BaseFluent<A>
implements IssuerListFluent<A> {
    private String apiVersion;
    private List<IssuerBuilder> items;
    private String kind;
    private ListMeta metadata;

    public IssuerListFluentImpl() {
    }

    public IssuerListFluentImpl(IssuerList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(int index, Issuer item) {
        if (this.items == null) {
            this.items = new ArrayList<IssuerBuilder>();
        }
        IssuerBuilder builder = new IssuerBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Issuer item) {
        if (this.items == null) {
            this.items = new ArrayList<IssuerBuilder>();
        }
        IssuerBuilder builder = new IssuerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Issuer ... items) {
        if (this.items == null) {
            this.items = new ArrayList<IssuerBuilder>();
        }
        for (Issuer item : items) {
            IssuerBuilder builder = new IssuerBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Issuer> items) {
        if (this.items == null) {
            this.items = new ArrayList<IssuerBuilder>();
        }
        for (Issuer item : items) {
            IssuerBuilder builder = new IssuerBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Issuer ... items) {
        for (Issuer item : items) {
            IssuerBuilder builder = new IssuerBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Issuer> items) {
        for (Issuer item : items) {
            IssuerBuilder builder = new IssuerBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<IssuerBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<IssuerBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            IssuerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Issuer> getItems() {
        return IssuerListFluentImpl.build(this.items);
    }

    @Override
    public List<Issuer> buildItems() {
        return IssuerListFluentImpl.build(this.items);
    }

    @Override
    public Issuer buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Issuer buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Issuer buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Issuer buildMatchingItem(Predicate<IssuerBuilder> predicate) {
        for (IssuerBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<IssuerBuilder> predicate) {
        for (IssuerBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<Issuer> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<IssuerBuilder>();
            for (Issuer item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(Issuer ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Issuer item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public IssuerListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public IssuerListFluent.ItemsNested<A> addNewItemLike(Issuer item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public IssuerListFluent.ItemsNested<A> setNewItemLike(int index, Issuer item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public IssuerListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public IssuerListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public IssuerListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public IssuerListFluent.ItemsNested<A> editMatchingItem(Predicate<IssuerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssuerListFluentImpl that = (IssuerListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends IssuerFluentImpl<IssuerListFluent.ItemsNested<N>>
    implements IssuerListFluent.ItemsNested<N>,
    Nested<N> {
        private final IssuerBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Issuer item) {
            this.index = index;
            this.builder = new IssuerBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new IssuerBuilder(this);
        }

        @Override
        public N and() {
            return (N)IssuerListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

