package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IssuerSpecBuilder extends io.fabric8.certmanager.api.model.v1alpha2.IssuerSpecFluentImpl<io.fabric8.certmanager.api.model.v1alpha2.IssuerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha2.IssuerSpec,io.fabric8.certmanager.api.model.v1alpha2.IssuerSpecBuilder> {

    io.fabric8.certmanager.api.model.v1alpha2.IssuerSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IssuerSpecBuilder() {
        this(true);
    }

    public IssuerSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new IssuerSpec(), validationEnabled);
    }

    public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.IssuerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.IssuerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IssuerSpec(), validationEnabled);
    }

    public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.IssuerSpecFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.IssuerSpec instance) {
        this(fluent, instance, true);
    }

    public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.IssuerSpecFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.IssuerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAcme(instance.getAcme()); 
        fluent.withCa(instance.getCa()); 
        fluent.withSelfSigned(instance.getSelfSigned()); 
        fluent.withVault(instance.getVault()); 
        fluent.withVenafi(instance.getVenafi()); 
        this.validationEnabled = validationEnabled; 
    }

    public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.IssuerSpec instance) {
        this(instance,true);
    }

    public IssuerSpecBuilder(io.fabric8.certmanager.api.model.v1alpha2.IssuerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAcme(instance.getAcme()); 
        this.withCa(instance.getCa()); 
        this.withSelfSigned(instance.getSelfSigned()); 
        this.withVault(instance.getVault()); 
        this.withVenafi(instance.getVenafi()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.certmanager.api.model.v1alpha2.EditableIssuerSpec build() {
        EditableIssuerSpec buildable = new EditableIssuerSpec(fluent.getAcme(),fluent.getCa(),fluent.getSelfSigned(),fluent.getVault(),fluent.getVenafi());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IssuerSpecBuilder that = (IssuerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
