package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterIssuerBuilder extends io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuerFluentImpl<io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuer,io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuerBuilder> {

    io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuerFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ClusterIssuerBuilder() {
        this(true);
    }

    public ClusterIssuerBuilder(java.lang.Boolean validationEnabled) {
        this(new ClusterIssuer(), validationEnabled);
    }

    public ClusterIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuerFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ClusterIssuer(), validationEnabled);
    }

    public ClusterIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuer instance) {
        this(fluent, instance, true);
    }

    public ClusterIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuer instance) {
        this(instance,true);
    }

    public ClusterIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha2.ClusterIssuer instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.certmanager.api.model.v1alpha2.EditableClusterIssuer build() {
        EditableClusterIssuer buildable = new EditableClusterIssuer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterIssuerBuilder that = (ClusterIssuerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
