
package io.fabric8.certmanager.api.model.acme.v1alpha2;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "apiKeySecretRef",
    "apiTokenSecretRef",
    "email"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class ACMEIssuerDNS01ProviderCloudflare implements KubernetesResource
{

    @JsonProperty("apiKeySecretRef")
    private SecretKeySelector apiKeySecretRef;
    @JsonProperty("apiTokenSecretRef")
    private SecretKeySelector apiTokenSecretRef;
    @JsonProperty("email")
    private String email;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ACMEIssuerDNS01ProviderCloudflare() {
    }

    /**
     * 
     * @param apiKeySecretRef
     * @param apiTokenSecretRef
     * @param email
     */
    public ACMEIssuerDNS01ProviderCloudflare(SecretKeySelector apiKeySecretRef, SecretKeySelector apiTokenSecretRef, String email) {
        super();
        this.apiKeySecretRef = apiKeySecretRef;
        this.apiTokenSecretRef = apiTokenSecretRef;
        this.email = email;
    }

    @JsonProperty("apiKeySecretRef")
    public SecretKeySelector getApiKeySecretRef() {
        return apiKeySecretRef;
    }

    @JsonProperty("apiKeySecretRef")
    public void setApiKeySecretRef(SecretKeySelector apiKeySecretRef) {
        this.apiKeySecretRef = apiKeySecretRef;
    }

    @JsonProperty("apiTokenSecretRef")
    public SecretKeySelector getApiTokenSecretRef() {
        return apiTokenSecretRef;
    }

    @JsonProperty("apiTokenSecretRef")
    public void setApiTokenSecretRef(SecretKeySelector apiTokenSecretRef) {
        this.apiTokenSecretRef = apiTokenSecretRef;
    }

    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    @JsonProperty("email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
