package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ACMEAuthorizationBuilder extends io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluentImpl<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorization,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationBuilder> {

    io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ACMEAuthorizationBuilder() {
        this(true);
    }

    public ACMEAuthorizationBuilder(java.lang.Boolean validationEnabled) {
        this(new ACMEAuthorization(), validationEnabled);
    }

    public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent<?> fluent) {
        this(fluent, true);
    }

    public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ACMEAuthorization(), validationEnabled);
    }

    public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorization instance) {
        this(fluent, instance, true);
    }

    public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorization instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withChallenges(instance.getChallenges()); 
        fluent.withIdentifier(instance.getIdentifier()); 
        fluent.withInitialState(instance.getInitialState()); 
        fluent.withUrl(instance.getUrl()); 
        fluent.withWildcard(instance.getWildcard()); 
        this.validationEnabled = validationEnabled; 
    }

    public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorization instance) {
        this(instance,true);
    }

    public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorization instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withChallenges(instance.getChallenges()); 
        this.withIdentifier(instance.getIdentifier()); 
        this.withInitialState(instance.getInitialState()); 
        this.withUrl(instance.getUrl()); 
        this.withWildcard(instance.getWildcard()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.EditableACMEAuthorization build() {
        EditableACMEAuthorization buildable = new EditableACMEAuthorization(fluent.getChallenges(),fluent.getIdentifier(),fluent.getInitialState(),fluent.getUrl(),fluent.getWildcard());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ACMEAuthorizationBuilder that = (ACMEAuthorizationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
