package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

public class VaultAuthFluentImpl<A extends io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent<A> {

    private io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleBuilder appRole;
    private io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthBuilder kubernetes;
    private io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder tokenSecretRef;

    public VaultAuthFluentImpl() {
    }

    public VaultAuthFluentImpl(io.fabric8.certmanager.api.model.v1alpha2.VaultAuth instance) {
        this.withAppRole(instance.getAppRole()); 
        this.withKubernetes(instance.getKubernetes()); 
        this.withTokenSecretRef(instance.getTokenSecretRef()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAppRole instead.
     * @return The buildable object.
     */
        public io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole getAppRole() {
        return this.appRole!=null?this.appRole.build():null;
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole buildAppRole() {
        return this.appRole!=null?this.appRole.build():null;
    }

    public A withAppRole(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole appRole) {
        _visitables.get("appRole").remove(this.appRole);
        if (appRole!=null){ this.appRole= new io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleBuilder(appRole); _visitables.get("appRole").add(this.appRole);} return (A) this;
    }

    public java.lang.Boolean hasAppRole() {
        return this.appRole != null;
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.AppRoleNested<A> withNewAppRole() {
        return new io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluentImpl.AppRoleNestedImpl();
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.AppRoleNested<A> withNewAppRoleLike(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole item) {
        return new io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluentImpl.AppRoleNestedImpl(item);
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.AppRoleNested<A> editAppRole() {
        return withNewAppRoleLike(getAppRole());
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.AppRoleNested<A> editOrNewAppRole() {
        return withNewAppRoleLike(getAppRole() != null ? getAppRole(): new io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleBuilder().build());
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.AppRoleNested<A> editOrNewAppRoleLike(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole item) {
        return withNewAppRoleLike(getAppRole() != null ? getAppRole(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKubernetes instead.
     * @return The buildable object.
     */
        public io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth getKubernetes() {
        return this.kubernetes!=null?this.kubernetes.build():null;
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth buildKubernetes() {
        return this.kubernetes!=null?this.kubernetes.build():null;
    }

    public A withKubernetes(io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth kubernetes) {
        _visitables.get("kubernetes").remove(this.kubernetes);
        if (kubernetes!=null){ this.kubernetes= new io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthBuilder(kubernetes); _visitables.get("kubernetes").add(this.kubernetes);} return (A) this;
    }

    public java.lang.Boolean hasKubernetes() {
        return this.kubernetes != null;
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.KubernetesNested<A> withNewKubernetes() {
        return new io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluentImpl.KubernetesNestedImpl();
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.KubernetesNested<A> withNewKubernetesLike(io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth item) {
        return new io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluentImpl.KubernetesNestedImpl(item);
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.KubernetesNested<A> editKubernetes() {
        return withNewKubernetesLike(getKubernetes());
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.KubernetesNested<A> editOrNewKubernetes() {
        return withNewKubernetesLike(getKubernetes() != null ? getKubernetes(): new io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthBuilder().build());
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.KubernetesNested<A> editOrNewKubernetesLike(io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth item) {
        return withNewKubernetesLike(getKubernetes() != null ? getKubernetes(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTokenSecretRef instead.
     * @return The buildable object.
     */
        public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector getTokenSecretRef() {
        return this.tokenSecretRef!=null?this.tokenSecretRef.build():null;
    }

    public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector buildTokenSecretRef() {
        return this.tokenSecretRef!=null?this.tokenSecretRef.build():null;
    }

    public A withTokenSecretRef(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector tokenSecretRef) {
        _visitables.get("tokenSecretRef").remove(this.tokenSecretRef);
        if (tokenSecretRef!=null){ this.tokenSecretRef= new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(tokenSecretRef); _visitables.get("tokenSecretRef").add(this.tokenSecretRef);} return (A) this;
    }

    public java.lang.Boolean hasTokenSecretRef() {
        return this.tokenSecretRef != null;
    }

    public A withNewTokenSecretRef(java.lang.String key,java.lang.String name) {
        return (A)withTokenSecretRef(new SecretKeySelector(key, name));
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.TokenSecretRefNested<A> withNewTokenSecretRef() {
        return new io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluentImpl.TokenSecretRefNestedImpl();
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.TokenSecretRefNested<A> withNewTokenSecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
        return new io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluentImpl.TokenSecretRefNestedImpl(item);
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.TokenSecretRefNested<A> editTokenSecretRef() {
        return withNewTokenSecretRefLike(getTokenSecretRef());
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.TokenSecretRefNested<A> editOrNewTokenSecretRef() {
        return withNewTokenSecretRefLike(getTokenSecretRef() != null ? getTokenSecretRef(): new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder().build());
    }

    public io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.TokenSecretRefNested<A> editOrNewTokenSecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
        return withNewTokenSecretRefLike(getTokenSecretRef() != null ? getTokenSecretRef(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VaultAuthFluentImpl that = (VaultAuthFluentImpl) o;
        if (appRole != null ? !appRole.equals(that.appRole) :that.appRole != null) return false;
        if (kubernetes != null ? !kubernetes.equals(that.kubernetes) :that.kubernetes != null) return false;
        if (tokenSecretRef != null ? !tokenSecretRef.equals(that.tokenSecretRef) :that.tokenSecretRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(appRole,  kubernetes,  tokenSecretRef,  super.hashCode());
    }

    public class AppRoleNestedImpl<N> extends io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleFluentImpl<io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.AppRoleNested<N>> implements io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.AppRoleNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleBuilder builder;

            AppRoleNestedImpl(io.fabric8.certmanager.api.model.v1alpha2.VaultAppRole item) {
                this.builder = new io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleBuilder(this, item);
                        
            }

            AppRoleNestedImpl() {
                this.builder = new io.fabric8.certmanager.api.model.v1alpha2.VaultAppRoleBuilder(this);
                        
            }

            public N and() {
                return (N) VaultAuthFluentImpl.this.withAppRole(builder.build());
            }

            public N endAppRole() {
                return and();
            }
    }


    public class KubernetesNestedImpl<N> extends io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthFluentImpl<io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.KubernetesNested<N>> implements io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.KubernetesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthBuilder builder;

            KubernetesNestedImpl(io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuth item) {
                this.builder = new io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthBuilder(this, item);
                        
            }

            KubernetesNestedImpl() {
                this.builder = new io.fabric8.certmanager.api.model.v1alpha2.VaultKubernetesAuthBuilder(this);
                        
            }

            public N and() {
                return (N) VaultAuthFluentImpl.this.withKubernetes(builder.build());
            }

            public N endKubernetes() {
                return and();
            }
    }


    public class TokenSecretRefNestedImpl<N> extends io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl<io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.TokenSecretRefNested<N>> implements io.fabric8.certmanager.api.model.v1alpha2.VaultAuthFluent.TokenSecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder builder;

            TokenSecretRefNestedImpl(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this, item);
                        
            }

            TokenSecretRefNestedImpl() {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this);
                        
            }

            public N and() {
                return (N) VaultAuthFluentImpl.this.withTokenSecretRef(builder.build());
            }

            public N endTokenSecretRef() {
                return and();
            }
    }


}
