package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CertificateStatusFluentImpl<A extends io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent<A> {

    private java.util.List<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder> conditions;
    private java.lang.String lastFailureTime;
    private java.lang.String nextPrivateKeySecretName;
    private java.lang.String notAfter;
    private java.lang.String notBefore;
    private java.lang.String renewalTime;
    private java.lang.Integer revision;

    public CertificateStatusFluentImpl() {
    }

    public CertificateStatusFluentImpl(io.fabric8.certmanager.api.model.v1alpha2.CertificateStatus instance) {
        this.withConditions(instance.getConditions()); 
        this.withLastFailureTime(instance.getLastFailureTime()); 
        this.withNextPrivateKeySecretName(instance.getNextPrivateKeySecretName()); 
        this.withNotAfter(instance.getNotAfter()); 
        this.withNotBefore(instance.getNotBefore()); 
        this.withRenewalTime(instance.getRenewalTime()); 
        this.withRevision(instance.getRevision()); 
    }

    public A addToConditions(int index,io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder>();}
        io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder builder = new io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder>();}
        io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder builder = new io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition... items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder>();}
        for (io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item : items) {io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder builder = new io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(java.util.Collection<io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition> items) {
        if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder>();}
        for (io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item : items) {io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder builder = new io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition... items) {
        for (io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item : items) {io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder builder = new io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(java.util.Collection<io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition> items) {
        for (io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item : items) {io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder builder = new io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConditions instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition> getConditions() {
        return build(conditions);
    }

    public java.util.List<io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder> predicate) {
        for (io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder> predicate) {
        for (io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(java.util.List<io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder>(); for (io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public java.lang.Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
        return (A)addToConditions(new CertificateCondition(lastTransitionTime, message, reason, status, type));
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent.ConditionsNested<A> addNewCondition() {
        return new io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluentImpl.ConditionsNestedImpl();
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item) {
        return new io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluentImpl.ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item) {
        return new io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluentImpl.ConditionsNestedImpl(index, item);
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public java.lang.String getLastFailureTime() {
        return this.lastFailureTime;
    }

    public A withLastFailureTime(java.lang.String lastFailureTime) {
        this.lastFailureTime=lastFailureTime; return (A) this;
    }

    public java.lang.Boolean hasLastFailureTime() {
        return this.lastFailureTime != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withLastFailureTime instead.
     */
        public A withNewLastFailureTime(java.lang.String arg0) {
        return (A)withLastFailureTime(new String(arg0));
    }

    public java.lang.String getNextPrivateKeySecretName() {
        return this.nextPrivateKeySecretName;
    }

    public A withNextPrivateKeySecretName(java.lang.String nextPrivateKeySecretName) {
        this.nextPrivateKeySecretName=nextPrivateKeySecretName; return (A) this;
    }

    public java.lang.Boolean hasNextPrivateKeySecretName() {
        return this.nextPrivateKeySecretName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNextPrivateKeySecretName instead.
     */
        public A withNewNextPrivateKeySecretName(java.lang.String arg0) {
        return (A)withNextPrivateKeySecretName(new String(arg0));
    }

    public java.lang.String getNotAfter() {
        return this.notAfter;
    }

    public A withNotAfter(java.lang.String notAfter) {
        this.notAfter=notAfter; return (A) this;
    }

    public java.lang.Boolean hasNotAfter() {
        return this.notAfter != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNotAfter instead.
     */
        public A withNewNotAfter(java.lang.String arg0) {
        return (A)withNotAfter(new String(arg0));
    }

    public java.lang.String getNotBefore() {
        return this.notBefore;
    }

    public A withNotBefore(java.lang.String notBefore) {
        this.notBefore=notBefore; return (A) this;
    }

    public java.lang.Boolean hasNotBefore() {
        return this.notBefore != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNotBefore instead.
     */
        public A withNewNotBefore(java.lang.String arg0) {
        return (A)withNotBefore(new String(arg0));
    }

    public java.lang.String getRenewalTime() {
        return this.renewalTime;
    }

    public A withRenewalTime(java.lang.String renewalTime) {
        this.renewalTime=renewalTime; return (A) this;
    }

    public java.lang.Boolean hasRenewalTime() {
        return this.renewalTime != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withRenewalTime instead.
     */
        public A withNewRenewalTime(java.lang.String arg0) {
        return (A)withRenewalTime(new String(arg0));
    }

    public java.lang.Integer getRevision() {
        return this.revision;
    }

    public A withRevision(java.lang.Integer revision) {
        this.revision=revision; return (A) this;
    }

    public java.lang.Boolean hasRevision() {
        return this.revision != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CertificateStatusFluentImpl that = (CertificateStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (lastFailureTime != null ? !lastFailureTime.equals(that.lastFailureTime) :that.lastFailureTime != null) return false;
        if (nextPrivateKeySecretName != null ? !nextPrivateKeySecretName.equals(that.nextPrivateKeySecretName) :that.nextPrivateKeySecretName != null) return false;
        if (notAfter != null ? !notAfter.equals(that.notAfter) :that.notAfter != null) return false;
        if (notBefore != null ? !notBefore.equals(that.notBefore) :that.notBefore != null) return false;
        if (renewalTime != null ? !renewalTime.equals(that.renewalTime) :that.renewalTime != null) return false;
        if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  lastFailureTime,  nextPrivateKeySecretName,  notAfter,  notBefore,  renewalTime,  revision,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionFluentImpl<io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent.ConditionsNested<N>> implements io.fabric8.certmanager.api.model.v1alpha2.CertificateStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.certmanager.api.model.v1alpha2.CertificateCondition item) {
                this.index = index;
                this.builder = new io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.certmanager.api.model.v1alpha2.CertificateConditionBuilder(this);
                        
            }

            public N and() {
                return (N) CertificateStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


}
