package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

public class ACMEExternalAccountBindingFluentImpl<A extends io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent<A> {

    private java.lang.String keyAlgorithm;
    private java.lang.String keyID;
    private io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder keySecretRef;

    public ACMEExternalAccountBindingFluentImpl() {
    }

    public ACMEExternalAccountBindingFluentImpl(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBinding instance) {
        this.withKeyAlgorithm(instance.getKeyAlgorithm()); 
        this.withKeyID(instance.getKeyID()); 
        this.withKeySecretRef(instance.getKeySecretRef()); 
    }

    public java.lang.String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public A withKeyAlgorithm(java.lang.String keyAlgorithm) {
        this.keyAlgorithm=keyAlgorithm; return (A) this;
    }

    public java.lang.Boolean hasKeyAlgorithm() {
        return this.keyAlgorithm != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKeyAlgorithm instead.
     */
        public A withNewKeyAlgorithm(java.lang.String arg0) {
        return (A)withKeyAlgorithm(new String(arg0));
    }

    public java.lang.String getKeyID() {
        return this.keyID;
    }

    public A withKeyID(java.lang.String keyID) {
        this.keyID=keyID; return (A) this;
    }

    public java.lang.Boolean hasKeyID() {
        return this.keyID != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKeyID instead.
     */
        public A withNewKeyID(java.lang.String arg0) {
        return (A)withKeyID(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKeySecretRef instead.
     * @return The buildable object.
     */
        public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector getKeySecretRef() {
        return this.keySecretRef!=null?this.keySecretRef.build():null;
    }

    public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector buildKeySecretRef() {
        return this.keySecretRef!=null?this.keySecretRef.build():null;
    }

    public A withKeySecretRef(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector keySecretRef) {
        _visitables.get("keySecretRef").remove(this.keySecretRef);
        if (keySecretRef!=null){ this.keySecretRef= new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(keySecretRef); _visitables.get("keySecretRef").add(this.keySecretRef);} return (A) this;
    }

    public java.lang.Boolean hasKeySecretRef() {
        return this.keySecretRef != null;
    }

    public A withNewKeySecretRef(java.lang.String key,java.lang.String name) {
        return (A)withKeySecretRef(new SecretKeySelector(key, name));
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent.KeySecretRefNested<A> withNewKeySecretRef() {
        return new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluentImpl.KeySecretRefNestedImpl();
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent.KeySecretRefNested<A> withNewKeySecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
        return new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluentImpl.KeySecretRefNestedImpl(item);
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent.KeySecretRefNested<A> editKeySecretRef() {
        return withNewKeySecretRefLike(getKeySecretRef());
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent.KeySecretRefNested<A> editOrNewKeySecretRef() {
        return withNewKeySecretRefLike(getKeySecretRef() != null ? getKeySecretRef(): new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder().build());
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent.KeySecretRefNested<A> editOrNewKeySecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
        return withNewKeySecretRefLike(getKeySecretRef() != null ? getKeySecretRef(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ACMEExternalAccountBindingFluentImpl that = (ACMEExternalAccountBindingFluentImpl) o;
        if (keyAlgorithm != null ? !keyAlgorithm.equals(that.keyAlgorithm) :that.keyAlgorithm != null) return false;
        if (keyID != null ? !keyID.equals(that.keyID) :that.keyID != null) return false;
        if (keySecretRef != null ? !keySecretRef.equals(that.keySecretRef) :that.keySecretRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(keyAlgorithm,  keyID,  keySecretRef,  super.hashCode());
    }

    public class KeySecretRefNestedImpl<N> extends io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent.KeySecretRefNested<N>> implements io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEExternalAccountBindingFluent.KeySecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder builder;

            KeySecretRefNestedImpl(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this, item);
                        
            }

            KeySecretRefNestedImpl() {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this);
                        
            }

            public N and() {
                return (N) ACMEExternalAccountBindingFluentImpl.this.withKeySecretRef(builder.build());
            }

            public N endKeySecretRef() {
                return and();
            }
    }


}
