package io.fabric8.certmanager.api.model.acme.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ACMEAuthorizationFluentImpl<A extends io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent<A> {

    private java.util.List<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder> challenges;
    private java.lang.String identifier;
    private java.lang.String initialState;
    private java.lang.String url;
    private java.lang.Boolean wildcard;

    public ACMEAuthorizationFluentImpl() {
    }

    public ACMEAuthorizationFluentImpl(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorization instance) {
        this.withChallenges(instance.getChallenges()); 
        this.withIdentifier(instance.getIdentifier()); 
        this.withInitialState(instance.getInitialState()); 
        this.withUrl(instance.getUrl()); 
        this.withWildcard(instance.getWildcard()); 
    }

    public A addToChallenges(int index,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item) {
        if (this.challenges == null) {this.challenges = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder>();}
        io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder(item);_visitables.get("challenges").add(index >= 0 ? index : _visitables.get("challenges").size(), builder);this.challenges.add(index >= 0 ? index : challenges.size(), builder); return (A)this;
    }

    public A setToChallenges(int index,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item) {
        if (this.challenges == null) {this.challenges = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder>();}
        io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder(item);
        if (index < 0 || index >= _visitables.get("challenges").size()) { _visitables.get("challenges").add(builder); } else { _visitables.get("challenges").set(index, builder);}
        if (index < 0 || index >= challenges.size()) { challenges.add(builder); } else { challenges.set(index, builder);}
         return (A)this;
    }

    public A addToChallenges(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge... items) {
        if (this.challenges == null) {this.challenges = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder>();}
        for (io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item : items) {io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder(item);_visitables.get("challenges").add(builder);this.challenges.add(builder);} return (A)this;
    }

    public A addAllToChallenges(java.util.Collection<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge> items) {
        if (this.challenges == null) {this.challenges = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder>();}
        for (io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item : items) {io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder(item);_visitables.get("challenges").add(builder);this.challenges.add(builder);} return (A)this;
    }

    public A removeFromChallenges(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge... items) {
        for (io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item : items) {io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder(item);_visitables.get("challenges").remove(builder);if (this.challenges != null) {this.challenges.remove(builder);}} return (A)this;
    }

    public A removeAllFromChallenges(java.util.Collection<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge> items) {
        for (io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item : items) {io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder(item);_visitables.get("challenges").remove(builder);if (this.challenges != null) {this.challenges.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromChallenges(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder> predicate) {
        if (challenges == null) return (A) this;
        final Iterator<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder> each = challenges.iterator();
        final List visitables = _visitables.get("challenges");
        while (each.hasNext()) {
          io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildChallenges instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge> getChallenges() {
        return build(challenges);
    }

    public java.util.List<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge> buildChallenges() {
        return build(challenges);
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge buildChallenge(int index) {
        return this.challenges.get(index).build();
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge buildFirstChallenge() {
        return this.challenges.get(0).build();
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge buildLastChallenge() {
        return this.challenges.get(challenges.size() - 1).build();
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge buildMatchingChallenge(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder> predicate) {
        for (io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder item: challenges) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingChallenge(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder> predicate) {
        for (io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder item: challenges) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withChallenges(java.util.List<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge> challenges) {
        if (this.challenges != null) { _visitables.get("challenges").removeAll(this.challenges);}
        if (challenges != null) {this.challenges = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder>(); for (io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item : challenges){this.addToChallenges(item);}} else { this.challenges = null;} return (A) this;
    }

    public A withChallenges(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge... challenges) {
        if (this.challenges != null) {this.challenges.clear();}
        if (challenges != null) {for (io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item :challenges){ this.addToChallenges(item);}} return (A) this;
    }

    public java.lang.Boolean hasChallenges() {
        return challenges != null && !challenges.isEmpty();
    }

    public A addNewChallenge(java.lang.String token,java.lang.String type,java.lang.String url) {
        return (A)addToChallenges(new ACMEChallenge(token, type, url));
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent.ChallengesNested<A> addNewChallenge() {
        return new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluentImpl.ChallengesNestedImpl();
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent.ChallengesNested<A> addNewChallengeLike(io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item) {
        return new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluentImpl.ChallengesNestedImpl(-1, item);
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent.ChallengesNested<A> setNewChallengeLike(int index,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item) {
        return new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluentImpl.ChallengesNestedImpl(index, item);
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent.ChallengesNested<A> editChallenge(int index) {
        if (challenges.size() <= index) throw new RuntimeException("Can't edit challenges. Index exceeds size.");
        return setNewChallengeLike(index, buildChallenge(index));
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent.ChallengesNested<A> editFirstChallenge() {
        if (challenges.size() == 0) throw new RuntimeException("Can't edit first challenges. The list is empty.");
        return setNewChallengeLike(0, buildChallenge(0));
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent.ChallengesNested<A> editLastChallenge() {
        int index = challenges.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last challenges. The list is empty.");
        return setNewChallengeLike(index, buildChallenge(index));
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent.ChallengesNested<A> editMatchingChallenge(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<challenges.size();i++) { 
        if (predicate.test(challenges.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching challenges. No match found.");
        return setNewChallengeLike(index, buildChallenge(index));
    }

    public java.lang.String getIdentifier() {
        return this.identifier;
    }

    public A withIdentifier(java.lang.String identifier) {
        this.identifier=identifier; return (A) this;
    }

    public java.lang.Boolean hasIdentifier() {
        return this.identifier != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withIdentifier instead.
     */
        public A withNewIdentifier(java.lang.String arg0) {
        return (A)withIdentifier(new String(arg0));
    }

    public java.lang.String getInitialState() {
        return this.initialState;
    }

    public A withInitialState(java.lang.String initialState) {
        this.initialState=initialState; return (A) this;
    }

    public java.lang.Boolean hasInitialState() {
        return this.initialState != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withInitialState instead.
     */
        public A withNewInitialState(java.lang.String arg0) {
        return (A)withInitialState(new String(arg0));
    }

    public java.lang.String getUrl() {
        return this.url;
    }

    public A withUrl(java.lang.String url) {
        this.url=url; return (A) this;
    }

    public java.lang.Boolean hasUrl() {
        return this.url != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withUrl instead.
     */
        public A withNewUrl(java.lang.String arg0) {
        return (A)withUrl(new String(arg0));
    }

    public java.lang.Boolean getWildcard() {
        return this.wildcard;
    }

    public A withWildcard(java.lang.Boolean wildcard) {
        this.wildcard=wildcard; return (A) this;
    }

    public java.lang.Boolean hasWildcard() {
        return this.wildcard != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ACMEAuthorizationFluentImpl that = (ACMEAuthorizationFluentImpl) o;
        if (challenges != null ? !challenges.equals(that.challenges) :that.challenges != null) return false;
        if (identifier != null ? !identifier.equals(that.identifier) :that.identifier != null) return false;
        if (initialState != null ? !initialState.equals(that.initialState) :that.initialState != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        if (wildcard != null ? !wildcard.equals(that.wildcard) :that.wildcard != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(challenges,  identifier,  initialState,  url,  wildcard,  super.hashCode());
    }

    public class ChallengesNestedImpl<N> extends io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeFluentImpl<io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent.ChallengesNested<N>> implements io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEAuthorizationFluent.ChallengesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder builder;
        private final int index;

            ChallengesNestedImpl(int index,io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallenge item) {
                this.index = index;
                this.builder = new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder(this, item);
                        
            }

            ChallengesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.certmanager.api.model.acme.v1alpha2.ACMEChallengeBuilder(this);
                        
            }

            public N and() {
                return (N) ACMEAuthorizationFluentImpl.this.setToChallenges(index,builder.build());
            }

            public N endChallenge() {
                return and();
            }
    }


}
