/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha2;

import io.fabric8.certmanager.api.model.v1alpha2.CAIssuer;
import io.fabric8.certmanager.api.model.v1alpha2.CAIssuerFluent;
import io.fabric8.certmanager.api.model.v1alpha2.CAIssuerFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class CAIssuerBuilder
extends CAIssuerFluentImpl<CAIssuerBuilder>
implements VisitableBuilder<CAIssuer, CAIssuerBuilder> {
    CAIssuerFluent<?> fluent;
    Boolean validationEnabled;

    public CAIssuerBuilder() {
        this(false);
    }

    public CAIssuerBuilder(Boolean validationEnabled) {
        this(new CAIssuer(), validationEnabled);
    }

    public CAIssuerBuilder(CAIssuerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CAIssuerBuilder(CAIssuerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CAIssuer(), validationEnabled);
    }

    public CAIssuerBuilder(CAIssuerFluent<?> fluent, CAIssuer instance) {
        this(fluent, instance, false);
    }

    public CAIssuerBuilder(CAIssuerFluent<?> fluent, CAIssuer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        fluent.withSecretName(instance.getSecretName());
        this.validationEnabled = validationEnabled;
    }

    public CAIssuerBuilder(CAIssuer instance) {
        this(instance, (Boolean)false);
    }

    public CAIssuerBuilder(CAIssuer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCrlDistributionPoints(instance.getCrlDistributionPoints());
        this.withSecretName(instance.getSecretName());
        this.validationEnabled = validationEnabled;
    }

    public CAIssuer build() {
        CAIssuer buildable = new CAIssuer(this.fluent.getCrlDistributionPoints(), this.fluent.getSecretName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CAIssuerBuilder that = (CAIssuerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

