/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camel.tooling.util.parser;

import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLTokenizer;
import de.pdark.decentxml.validation.CharValidator;

public class PatchedXMLTokenizer
extends XMLTokenizer {
    private CharValidator charValidator = new CharValidator();

    public PatchedXMLTokenizer(XMLSource source) {
        super(source);
    }

    @Override
    protected void parseAttribute(Token token) {
        token.setType(XMLTokenizer.Type.ATTRIBUTE);
        this.parseName("attribute");
        if (this.pos == token.getStartOffset()) {
            throw new XMLParseException("Expected attribute name", this.source, this.pos);
        }
        this.skipWhiteSpace();
        this.expect('=');
        this.skipWhiteSpace();
        char c = '\u0000';
        if (this.pos < this.source.length()) {
            c = this.source.charAt(this.pos);
        }
        if (c != '\'' && c != '\"') {
            throw new XMLParseException("Expected single or double quotes", this.source, this.pos);
        }
        char endChar = c;
        boolean insideEntity = false;
        int errorPos = this.pos;
        while (true) {
            ++this.pos;
            if (this.pos >= this.source.length()) {
                int i = Math.min(20, this.source.length() - token.getStartOffset());
                throw new XMLParseException("Missing end quote (" + endChar + ") of attribute: " + this.lookAheadForErrorMessage(null, token.getStartOffset(), i), token);
            }
            c = this.source.charAt(this.pos);
            if (c == endChar) break;
            if (c == '<') {
                throw new XMLParseException("Illegal character in attribute value: '" + c + "'", this.source, this.pos);
            }
            if (c == '&') {
                insideEntity = true;
                errorPos = this.pos;
                continue;
            }
            if (c == ';') {
                this.verifyEntity(errorPos, this.pos + 1);
                insideEntity = false;
                continue;
            }
            String msg = this.charValidator.isValid(this.source, this.pos);
            if (msg != null) {
                throw new XMLParseException("Illegal character found in attribute value. " + msg, this.source, this.pos);
            }
            this.skipChar(c);
            --this.pos;
        }
        if (insideEntity) {
            throw new XMLParseException("Missing ';' after '&': " + this.lookAheadForErrorMessage(null, errorPos, 20), this.source, errorPos);
        }
        ++this.pos;
    }
}

