package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KameletBindingBuilder extends KameletBindingFluentImpl<KameletBindingBuilder> implements VisitableBuilder<KameletBinding,KameletBindingBuilder>{
  public KameletBindingBuilder() {
    this(false);
  }
  public KameletBindingBuilder(Boolean validationEnabled) {
    this(new KameletBinding(), validationEnabled);
  }
  public KameletBindingBuilder(KameletBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public KameletBindingBuilder(KameletBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KameletBinding(), validationEnabled);
  }
  public KameletBindingBuilder(KameletBindingFluent<?> fluent,KameletBinding instance) {
    this(fluent, instance, false);
  }
  public KameletBindingBuilder(KameletBindingFluent<?> fluent,KameletBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KameletBindingBuilder(KameletBinding instance) {
    this(instance,false);
  }
  public KameletBindingBuilder(KameletBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  KameletBindingFluent<?> fluent;
  Boolean validationEnabled;
  public KameletBinding build() {
    KameletBinding buildable = new KameletBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}