package io.fabric8.camelk.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JSONSchemaPropsFluentImpl<A extends JSONSchemaPropsFluent<A>> extends BaseFluent<A> implements JSONSchemaPropsFluent<A>{
  public JSONSchemaPropsFluentImpl() {
  }
  public JSONSchemaPropsFluentImpl(JSONSchemaProps instance) {
    if (instance != null) {
      this.withSchema(instance.get$schema());
      this.withDescription(instance.getDescription());
      this.withExample(instance.getExample());
      this.withExternalDocs(instance.getExternalDocs());
      this.withId(instance.getId());
      this.withProperties(instance.getProperties());
      this.withRequired(instance.getRequired());
      this.withTitle(instance.getTitle());
      this.withType(instance.getType());
    }
  }
  private String $schema;
  private String description;
  private JsonNode example;
  private ExternalDocumentationBuilder externalDocs;
  private String id;
  private Map<String,JSONSchemaProp> properties;
  private List<String> required = new ArrayList<String>();
  private String title;
  private String type;
  public String getSchema() {
    return this.$schema;
  }
  public A withSchema(String $schema) {
    this.$schema=$schema; return (A) this;
  }
  public Boolean hasSchema() {
    return this.$schema != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public JsonNode getExample() {
    return this.example;
  }
  public A withExample(JsonNode example) {
    this.example=example; return (A) this;
  }
  public Boolean hasExample() {
    return this.example != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExternalDocs instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExternalDocumentation getExternalDocs() {
    return this.externalDocs!=null ?this.externalDocs.build():null;
  }
  public ExternalDocumentation buildExternalDocs() {
    return this.externalDocs!=null ?this.externalDocs.build():null;
  }
  public A withExternalDocs(ExternalDocumentation externalDocs) {
    _visitables.get("externalDocs").remove(this.externalDocs);
    if (externalDocs!=null){ this.externalDocs= new ExternalDocumentationBuilder(externalDocs); _visitables.get("externalDocs").add(this.externalDocs);} else { this.externalDocs = null; _visitables.get("externalDocs").remove(this.externalDocs); } return (A) this;
  }
  public Boolean hasExternalDocs() {
    return this.externalDocs != null;
  }
  public A withNewExternalDocs(String description,String url) {
    return (A)withExternalDocs(new ExternalDocumentation(description, url));
  }
  public JSONSchemaPropsFluentImpl.ExternalDocsNested<A> withNewExternalDocs() {
    return new JSONSchemaPropsFluentImpl.ExternalDocsNestedImpl();
  }
  public JSONSchemaPropsFluentImpl.ExternalDocsNested<A> withNewExternalDocsLike(ExternalDocumentation item) {
    return new JSONSchemaPropsFluentImpl.ExternalDocsNestedImpl(item);
  }
  public JSONSchemaPropsFluentImpl.ExternalDocsNested<A> editExternalDocs() {
    return withNewExternalDocsLike(getExternalDocs());
  }
  public JSONSchemaPropsFluentImpl.ExternalDocsNested<A> editOrNewExternalDocs() {
    return withNewExternalDocsLike(getExternalDocs() != null ? getExternalDocs(): new ExternalDocumentationBuilder().build());
  }
  public JSONSchemaPropsFluentImpl.ExternalDocsNested<A> editOrNewExternalDocsLike(ExternalDocumentation item) {
    return withNewExternalDocsLike(getExternalDocs() != null ? getExternalDocs(): item);
  }
  public String getId() {
    return this.id;
  }
  public A withId(String id) {
    this.id=id; return (A) this;
  }
  public Boolean hasId() {
    return this.id != null;
  }
  public A addToProperties(String key,JSONSchemaProp value) {
    if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap(); }
    if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
  }
  public A addToProperties(Map<String,JSONSchemaProp> map) {
    if(this.properties == null && map != null) { this.properties = new LinkedHashMap(); }
    if(map != null) { this.properties.putAll(map);} return (A)this;
  }
  public A removeFromProperties(String key) {
    if(this.properties == null) { return (A) this; }
    if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
  }
  public A removeFromProperties(Map<String,JSONSchemaProp> map) {
    if(this.properties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
  }
  public Map<String,JSONSchemaProp> getProperties() {
    return this.properties;
  }
  public <K,V>A withProperties(Map<String,JSONSchemaProp> properties) {
    if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap(properties);} return (A) this;
  }
  public Boolean hasProperties() {
    return this.properties != null;
  }
  public A addToRequired(int index,String item) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    this.required.add(index, item);
    return (A)this;
  }
  public A setToRequired(int index,String item) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    this.required.set(index, item); return (A)this;
  }
  public A addToRequired(java.lang.String... items) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    for (String item : items) {this.required.add(item);} return (A)this;
  }
  public A addAllToRequired(Collection<String> items) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    for (String item : items) {this.required.add(item);} return (A)this;
  }
  public A removeFromRequired(java.lang.String... items) {
    for (String item : items) {if (this.required!= null){ this.required.remove(item);}} return (A)this;
  }
  public A removeAllFromRequired(Collection<String> items) {
    for (String item : items) {if (this.required!= null){ this.required.remove(item);}} return (A)this;
  }
  public List<String> getRequired() {
    return this.required;
  }
  public String getRequired(int index) {
    return this.required.get(index);
  }
  public String getFirstRequired() {
    return this.required.get(0);
  }
  public String getLastRequired() {
    return this.required.get(required.size() - 1);
  }
  public String getMatchingRequired(Predicate<String> predicate) {
    for (String item: required) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRequired(Predicate<String> predicate) {
    for (String item: required) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRequired(List<String> required) {
    if (required != null) {this.required = new ArrayList(); for (String item : required){this.addToRequired(item);}} else { this.required = null;} return (A) this;
  }
  public A withRequired(java.lang.String... required) {
    if (this.required != null) {this.required.clear(); _visitables.remove("required"); }
    if (required != null) {for (String item :required){ this.addToRequired(item);}} return (A) this;
  }
  public Boolean hasRequired() {
    return required != null && !required.isEmpty();
  }
  public String getTitle() {
    return this.title;
  }
  public A withTitle(String title) {
    this.title=title; return (A) this;
  }
  public Boolean hasTitle() {
    return this.title != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JSONSchemaPropsFluentImpl that = (JSONSchemaPropsFluentImpl) o;
    if (!java.util.Objects.equals($schema, that.$schema)) return false;

    if (!java.util.Objects.equals(description, that.description)) return false;

    if (!java.util.Objects.equals(example, that.example)) return false;

    if (!java.util.Objects.equals(externalDocs, that.externalDocs)) return false;

    if (!java.util.Objects.equals(id, that.id)) return false;

    if (!java.util.Objects.equals(properties, that.properties)) return false;

    if (!java.util.Objects.equals(required, that.required)) return false;

    if (!java.util.Objects.equals(title, that.title)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash($schema,  description,  example,  externalDocs,  id,  properties,  required,  title,  type,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if ($schema != null) { sb.append("$schema:"); sb.append($schema + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (example != null) { sb.append("example:"); sb.append(example + ","); }
    if (externalDocs != null) { sb.append("externalDocs:"); sb.append(externalDocs + ","); }
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (properties != null && !properties.isEmpty()) { sb.append("properties:"); sb.append(properties + ","); }
    if (required != null && !required.isEmpty()) { sb.append("required:"); sb.append(required + ","); }
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (type != null) { sb.append("type:"); sb.append(type); }
    sb.append("}");
    return sb.toString();
  }
  class ExternalDocsNestedImpl<N> extends ExternalDocumentationFluentImpl<JSONSchemaPropsFluentImpl.ExternalDocsNested<N>> implements JSONSchemaPropsFluentImpl.ExternalDocsNested<N>,Nested<N>{
    ExternalDocsNestedImpl(ExternalDocumentation item) {
      this.builder = new ExternalDocumentationBuilder(this, item);
    }
    ExternalDocsNestedImpl() {
      this.builder = new ExternalDocumentationBuilder(this);
    }
    ExternalDocumentationBuilder builder;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.withExternalDocs(builder.build());
    }
    public N endExternalDocs() {
      return and();
    }
    
  }
  
}