package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JSONSchemaPropBuilder extends JSONSchemaPropFluentImpl<JSONSchemaPropBuilder> implements VisitableBuilder<JSONSchemaProp,JSONSchemaPropBuilder>{
  public JSONSchemaPropBuilder() {
    this(false);
  }
  public JSONSchemaPropBuilder(Boolean validationEnabled) {
    this(new JSONSchemaProp(), validationEnabled);
  }
  public JSONSchemaPropBuilder(JSONSchemaPropFluent<?> fluent) {
    this(fluent, false);
  }
  public JSONSchemaPropBuilder(JSONSchemaPropFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JSONSchemaProp(), validationEnabled);
  }
  public JSONSchemaPropBuilder(JSONSchemaPropFluent<?> fluent,JSONSchemaProp instance) {
    this(fluent, instance, false);
  }
  public JSONSchemaPropBuilder(JSONSchemaPropFluent<?> fluent,JSONSchemaProp instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDefault(instance.getDefault());
      fluent.withDescription(instance.getDescription());
      fluent.withEnum(instance.getEnum());
      fluent.withExample(instance.getExample());
      fluent.withExclusiveMaximum(instance.getExclusiveMaximum());
      fluent.withExclusiveMinimum(instance.getExclusiveMinimum());
      fluent.withFormat(instance.getFormat());
      fluent.withId(instance.getId());
      fluent.withMaxItems(instance.getMaxItems());
      fluent.withMaxLength(instance.getMaxLength());
      fluent.withMaxProperties(instance.getMaxProperties());
      fluent.withMaximum(instance.getMaximum());
      fluent.withMinItems(instance.getMinItems());
      fluent.withMinLength(instance.getMinLength());
      fluent.withMinProperties(instance.getMinProperties());
      fluent.withMinimum(instance.getMinimum());
      fluent.withMultipleOf(instance.getMultipleOf());
      fluent.withNullable(instance.getNullable());
      fluent.withPattern(instance.getPattern());
      fluent.withTitle(instance.getTitle());
      fluent.withType(instance.getType());
      fluent.withUniqueItems(instance.getUniqueItems());
      fluent.withXDescriptors(instance.getXDescriptors());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JSONSchemaPropBuilder(JSONSchemaProp instance) {
    this(instance,false);
  }
  public JSONSchemaPropBuilder(JSONSchemaProp instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDefault(instance.getDefault());
      this.withDescription(instance.getDescription());
      this.withEnum(instance.getEnum());
      this.withExample(instance.getExample());
      this.withExclusiveMaximum(instance.getExclusiveMaximum());
      this.withExclusiveMinimum(instance.getExclusiveMinimum());
      this.withFormat(instance.getFormat());
      this.withId(instance.getId());
      this.withMaxItems(instance.getMaxItems());
      this.withMaxLength(instance.getMaxLength());
      this.withMaxProperties(instance.getMaxProperties());
      this.withMaximum(instance.getMaximum());
      this.withMinItems(instance.getMinItems());
      this.withMinLength(instance.getMinLength());
      this.withMinProperties(instance.getMinProperties());
      this.withMinimum(instance.getMinimum());
      this.withMultipleOf(instance.getMultipleOf());
      this.withNullable(instance.getNullable());
      this.withPattern(instance.getPattern());
      this.withTitle(instance.getTitle());
      this.withType(instance.getType());
      this.withUniqueItems(instance.getUniqueItems());
      this.withXDescriptors(instance.getXDescriptors());
    }
    this.validationEnabled = validationEnabled; 
  }
  JSONSchemaPropFluent<?> fluent;
  Boolean validationEnabled;
  public JSONSchemaProp build() {
    JSONSchemaProp buildable = new JSONSchemaProp(fluent.getDefault(),fluent.getDescription(),fluent.getEnum(),fluent.getExample(),fluent.getExclusiveMaximum(),fluent.getExclusiveMinimum(),fluent.getFormat(),fluent.getId(),fluent.getMaxItems(),fluent.getMaxLength(),fluent.getMaxProperties(),fluent.getMaximum(),fluent.getMinItems(),fluent.getMinLength(),fluent.getMinProperties(),fluent.getMinimum(),fluent.getMultipleOf(),fluent.getNullable(),fluent.getPattern(),fluent.getTitle(),fluent.getType(),fluent.getUniqueItems(),fluent.getXDescriptors());
    return buildable;
  }
  
}