package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalDocumentationBuilder extends ExternalDocumentationFluentImpl<ExternalDocumentationBuilder> implements VisitableBuilder<ExternalDocumentation,ExternalDocumentationBuilder>{
  public ExternalDocumentationBuilder() {
    this(false);
  }
  public ExternalDocumentationBuilder(Boolean validationEnabled) {
    this(new ExternalDocumentation(), validationEnabled);
  }
  public ExternalDocumentationBuilder(ExternalDocumentationFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalDocumentationBuilder(ExternalDocumentationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalDocumentation(), validationEnabled);
  }
  public ExternalDocumentationBuilder(ExternalDocumentationFluent<?> fluent,ExternalDocumentation instance) {
    this(fluent, instance, false);
  }
  public ExternalDocumentationBuilder(ExternalDocumentationFluent<?> fluent,ExternalDocumentation instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalDocumentationBuilder(ExternalDocumentation instance) {
    this(instance,false);
  }
  public ExternalDocumentationBuilder(ExternalDocumentation instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalDocumentationFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalDocumentation build() {
    ExternalDocumentation buildable = new ExternalDocumentation(fluent.getDescription(),fluent.getUrl());
    return buildable;
  }
  
}