package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventTypeSpecBuilder extends EventTypeSpecFluentImpl<EventTypeSpecBuilder> implements VisitableBuilder<EventTypeSpec,EventTypeSpecBuilder>{
  public EventTypeSpecBuilder() {
    this(false);
  }
  public EventTypeSpecBuilder(Boolean validationEnabled) {
    this(new EventTypeSpec(), validationEnabled);
  }
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventTypeSpec(), validationEnabled);
  }
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,EventTypeSpec instance) {
    this(fluent, instance, false);
  }
  public EventTypeSpecBuilder(EventTypeSpecFluent<?> fluent,EventTypeSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMediaType(instance.getMediaType());
      fluent.withSchema(instance.getSchema());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EventTypeSpecBuilder(EventTypeSpec instance) {
    this(instance,false);
  }
  public EventTypeSpecBuilder(EventTypeSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMediaType(instance.getMediaType());
      this.withSchema(instance.getSchema());
    }
    this.validationEnabled = validationEnabled; 
  }
  EventTypeSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EventTypeSpec build() {
    EventTypeSpec buildable = new EventTypeSpec(fluent.getMediaType(),fluent.getSchema());
    return buildable;
  }
  
}