package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointBuilder extends EndpointFluentImpl<EndpointBuilder> implements VisitableBuilder<Endpoint,EndpointBuilder>{
  public EndpointBuilder() {
    this(false);
  }
  public EndpointBuilder(Boolean validationEnabled) {
    this(new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(EndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointBuilder(EndpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance) {
    this(fluent, instance, false);
  }
  public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withProperties(instance.getProperties());
      fluent.withRef(instance.getRef());
      fluent.withTypes(instance.getTypes());
      fluent.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EndpointBuilder(Endpoint instance) {
    this(instance,false);
  }
  public EndpointBuilder(Endpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withProperties(instance.getProperties());
      this.withRef(instance.getRef());
      this.withTypes(instance.getTypes());
      this.withUri(instance.getUri());
    }
    this.validationEnabled = validationEnabled; 
  }
  EndpointFluent<?> fluent;
  Boolean validationEnabled;
  public Endpoint build() {
    Endpoint buildable = new Endpoint(fluent.getProperties(),fluent.getRef(),fluent.getTypes(),fluent.getUri());
    return buildable;
  }
  
}