package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KameletListBuilder extends KameletListFluentImpl<KameletListBuilder> implements VisitableBuilder<KameletList,KameletListBuilder>{
  public KameletListBuilder() {
    this(false);
  }
  public KameletListBuilder(Boolean validationEnabled) {
    this(new KameletList(), validationEnabled);
  }
  public KameletListBuilder(KameletListFluent<?> fluent) {
    this(fluent, false);
  }
  public KameletListBuilder(KameletListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KameletList(), validationEnabled);
  }
  public KameletListBuilder(KameletListFluent<?> fluent,KameletList instance) {
    this(fluent, instance, false);
  }
  public KameletListBuilder(KameletListFluent<?> fluent,KameletList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public KameletListBuilder(KameletList instance) {
    this(instance,false);
  }
  public KameletListBuilder(KameletList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  KameletListFluent<?> fluent;
  Boolean validationEnabled;
  public KameletList build() {
    KameletList buildable = new KameletList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}