package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KameletConditionBuilder extends KameletConditionFluentImpl<KameletConditionBuilder> implements VisitableBuilder<KameletCondition,KameletConditionBuilder>{
  public KameletConditionBuilder() {
    this(false);
  }
  public KameletConditionBuilder(Boolean validationEnabled) {
    this(new KameletCondition(), validationEnabled);
  }
  public KameletConditionBuilder(KameletConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public KameletConditionBuilder(KameletConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KameletCondition(), validationEnabled);
  }
  public KameletConditionBuilder(KameletConditionFluent<?> fluent,KameletCondition instance) {
    this(fluent, instance, false);
  }
  public KameletConditionBuilder(KameletConditionFluent<?> fluent,KameletCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public KameletConditionBuilder(KameletCondition instance) {
    this(instance,false);
  }
  public KameletConditionBuilder(KameletCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withLastUpdateTime(instance.getLastUpdateTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  KameletConditionFluent<?> fluent;
  Boolean validationEnabled;
  public KameletCondition build() {
    KameletCondition buildable = new KameletCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}