package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KameletBindingSpecBuilder extends KameletBindingSpecFluentImpl<KameletBindingSpecBuilder> implements VisitableBuilder<KameletBindingSpec,KameletBindingSpecBuilder>{
  public KameletBindingSpecBuilder() {
    this(false);
  }
  public KameletBindingSpecBuilder(Boolean validationEnabled) {
    this(new KameletBindingSpec(), validationEnabled);
  }
  public KameletBindingSpecBuilder(KameletBindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KameletBindingSpecBuilder(KameletBindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KameletBindingSpec(), validationEnabled);
  }
  public KameletBindingSpecBuilder(KameletBindingSpecFluent<?> fluent,KameletBindingSpec instance) {
    this(fluent, instance, false);
  }
  public KameletBindingSpecBuilder(KameletBindingSpecFluent<?> fluent,KameletBindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withErrorHandler(instance.getErrorHandler()); 
    fluent.withIntegration(instance.getIntegration()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withSink(instance.getSink()); 
    fluent.withSource(instance.getSource()); 
    fluent.withSteps(instance.getSteps()); 
    this.validationEnabled = validationEnabled; 
  }
  public KameletBindingSpecBuilder(KameletBindingSpec instance) {
    this(instance,false);
  }
  public KameletBindingSpecBuilder(KameletBindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withErrorHandler(instance.getErrorHandler()); 
    this.withIntegration(instance.getIntegration()); 
    this.withReplicas(instance.getReplicas()); 
    this.withSink(instance.getSink()); 
    this.withSource(instance.getSource()); 
    this.withSteps(instance.getSteps()); 
    this.validationEnabled = validationEnabled; 
  }
  KameletBindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KameletBindingSpec build() {
    KameletBindingSpec buildable = new KameletBindingSpec(fluent.getErrorHandler(),fluent.getIntegration(),fluent.getReplicas(),fluent.getSink(),fluent.getSource(),fluent.getSteps());
    return buildable;
  }
  
}