package io.fabric8.camelk.v1alpha1;

import io.fabric8.camelk.v1.SourceSpec;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KameletSpecFluentImpl<A extends KameletSpecFluent<A>> extends BaseFluent<A> implements KameletSpecFluent<A>{
  public KameletSpecFluentImpl() {
  }
  public KameletSpecFluentImpl(KameletSpec instance) {
    this.withAuthorization(instance.getAuthorization()); 
    this.withDefinition(instance.getDefinition()); 
    this.withDependencies(instance.getDependencies()); 
    this.withFlow(instance.getFlow()); 
    this.withSources(instance.getSources()); 
    this.withTemplate(instance.getTemplate()); 
    this.withTypes(instance.getTypes()); 
  }
  private AuthorizationSpecBuilder authorization;
  private JSONSchemaPropsBuilder definition;
  private List<String> dependencies = new ArrayList<String>();
  private JsonNode flow;
  private List<SourceSpec> sources = new ArrayList<SourceSpec>();
  private Map<String,Object> template;
  private Map<String,EventTypeSpec> types;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public AuthorizationSpec getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public AuthorizationSpec buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(AuthorizationSpec authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new AuthorizationSpecBuilder(authorization); _visitables.get("authorization").add(this.authorization);} else { this.authorization = null; _visitables.get("authorization").remove(this.authorization); } return (A) this;
  }
  public Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public KameletSpecFluent.AuthorizationNested<A> withNewAuthorization() {
    return new KameletSpecFluentImpl.AuthorizationNestedImpl();
  }
  public KameletSpecFluent.AuthorizationNested<A> withNewAuthorizationLike(AuthorizationSpec item) {
    return new KameletSpecFluentImpl.AuthorizationNestedImpl(item);
  }
  public KameletSpecFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public KameletSpecFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new AuthorizationSpecBuilder().build());
  }
  public KameletSpecFluent.AuthorizationNested<A> editOrNewAuthorizationLike(AuthorizationSpec item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDefinition instead.
   * @return The buildable object.
   */
  @Deprecated
  public JSONSchemaProps getDefinition() {
    return this.definition!=null ?this.definition.build():null;
  }
  public JSONSchemaProps buildDefinition() {
    return this.definition!=null ?this.definition.build():null;
  }
  public A withDefinition(JSONSchemaProps definition) {
    _visitables.get("definition").remove(this.definition);
    if (definition!=null){ this.definition= new JSONSchemaPropsBuilder(definition); _visitables.get("definition").add(this.definition);} else { this.definition = null; _visitables.get("definition").remove(this.definition); } return (A) this;
  }
  public Boolean hasDefinition() {
    return this.definition != null;
  }
  public KameletSpecFluent.DefinitionNested<A> withNewDefinition() {
    return new KameletSpecFluentImpl.DefinitionNestedImpl();
  }
  public KameletSpecFluent.DefinitionNested<A> withNewDefinitionLike(JSONSchemaProps item) {
    return new KameletSpecFluentImpl.DefinitionNestedImpl(item);
  }
  public KameletSpecFluent.DefinitionNested<A> editDefinition() {
    return withNewDefinitionLike(getDefinition());
  }
  public KameletSpecFluent.DefinitionNested<A> editOrNewDefinition() {
    return withNewDefinitionLike(getDefinition() != null ? getDefinition(): new JSONSchemaPropsBuilder().build());
  }
  public KameletSpecFluent.DefinitionNested<A> editOrNewDefinitionLike(JSONSchemaProps item) {
    return withNewDefinitionLike(getDefinition() != null ? getDefinition(): item);
  }
  public A addToDependencies(Integer index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.add(index, item);
    return (A)this;
  }
  public A setToDependencies(Integer index,String item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    this.dependencies.set(index, item); return (A)this;
  }
  public A addToDependencies(java.lang.String... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A addAllToDependencies(Collection<String> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
    for (String item : items) {this.dependencies.add(item);} return (A)this;
  }
  public A removeFromDependencies(java.lang.String... items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<String> items) {
    for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
  }
  public List<String> getDependencies() {
    return this.dependencies;
  }
  public String getDependency(Integer index) {
    return this.dependencies.get(index);
  }
  public String getFirstDependency() {
    return this.dependencies.get(0);
  }
  public String getLastDependency() {
    return this.dependencies.get(dependencies.size() - 1);
  }
  public String getMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<String> predicate) {
    for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDependencies(List<String> dependencies) {
    if (dependencies != null) {this.dependencies = new ArrayList(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
  }
  public A withDependencies(java.lang.String... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public JsonNode getFlow() {
    return this.flow;
  }
  public A withFlow(JsonNode flow) {
    this.flow=flow; return (A) this;
  }
  public Boolean hasFlow() {
    return this.flow != null;
  }
  public A addToSources(Integer index,SourceSpec item) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpec>();}
    this.sources.add(index, item);
    return (A)this;
  }
  public A setToSources(Integer index,SourceSpec item) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpec>();}
    this.sources.set(index, item); return (A)this;
  }
  public A addToSources(io.fabric8.camelk.v1.SourceSpec... items) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpec>();}
    for (SourceSpec item : items) {this.sources.add(item);} return (A)this;
  }
  public A addAllToSources(Collection<SourceSpec> items) {
    if (this.sources == null) {this.sources = new ArrayList<SourceSpec>();}
    for (SourceSpec item : items) {this.sources.add(item);} return (A)this;
  }
  public A removeFromSources(io.fabric8.camelk.v1.SourceSpec... items) {
    for (SourceSpec item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
  }
  public A removeAllFromSources(Collection<SourceSpec> items) {
    for (SourceSpec item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
  }
  public List<SourceSpec> getSources() {
    return this.sources;
  }
  public SourceSpec getSource(Integer index) {
    return this.sources.get(index);
  }
  public SourceSpec getFirstSource() {
    return this.sources.get(0);
  }
  public SourceSpec getLastSource() {
    return this.sources.get(sources.size() - 1);
  }
  public SourceSpec getMatchingSource(Predicate<SourceSpec> predicate) {
    for (SourceSpec item: sources) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSource(Predicate<SourceSpec> predicate) {
    for (SourceSpec item: sources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSources(List<SourceSpec> sources) {
    if (sources != null) {this.sources = new ArrayList(); for (SourceSpec item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
  }
  public A withSources(io.fabric8.camelk.v1.SourceSpec... sources) {
    if (this.sources != null) {this.sources.clear();}
    if (sources != null) {for (SourceSpec item :sources){ this.addToSources(item);}} return (A) this;
  }
  public Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public A addToTemplate(String key,Object value) {
    if(this.template == null && key != null && value != null) { this.template = new LinkedHashMap(); }
    if(key != null && value != null) {this.template.put(key, value);} return (A)this;
  }
  public A addToTemplate(Map<String,Object> map) {
    if(this.template == null && map != null) { this.template = new LinkedHashMap(); }
    if(map != null) { this.template.putAll(map);} return (A)this;
  }
  public A removeFromTemplate(String key) {
    if(this.template == null) { return (A) this; }
    if(key != null && this.template != null) {this.template.remove(key);} return (A)this;
  }
  public A removeFromTemplate(Map<String,Object> map) {
    if(this.template == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.template != null){this.template.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getTemplate() {
    return this.template;
  }
  public <K,V>A withTemplate(Map<String,Object> template) {
    if (template == null) { this.template =  null;} else {this.template = new LinkedHashMap(template);} return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public A addToTypes(String key,EventTypeSpec value) {
    if(this.types == null && key != null && value != null) { this.types = new LinkedHashMap(); }
    if(key != null && value != null) {this.types.put(key, value);} return (A)this;
  }
  public A addToTypes(Map<String,EventTypeSpec> map) {
    if(this.types == null && map != null) { this.types = new LinkedHashMap(); }
    if(map != null) { this.types.putAll(map);} return (A)this;
  }
  public A removeFromTypes(String key) {
    if(this.types == null) { return (A) this; }
    if(key != null && this.types != null) {this.types.remove(key);} return (A)this;
  }
  public A removeFromTypes(Map<String,EventTypeSpec> map) {
    if(this.types == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.types != null){this.types.remove(key);}}} return (A)this;
  }
  public Map<String,EventTypeSpec> getTypes() {
    return this.types;
  }
  public <K,V>A withTypes(Map<String,EventTypeSpec> types) {
    if (types == null) { this.types =  null;} else {this.types = new LinkedHashMap(types);} return (A) this;
  }
  public Boolean hasTypes() {
    return this.types != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KameletSpecFluentImpl that = (KameletSpecFluentImpl) o;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (definition != null ? !definition.equals(that.definition) :that.definition != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (flow != null ? !flow.equals(that.flow) :that.flow != null) return false;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (types != null ? !types.equals(that.types) :that.types != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  definition,  dependencies,  flow,  sources,  template,  types,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (definition != null) { sb.append("definition:"); sb.append(definition + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (flow != null) { sb.append("flow:"); sb.append(flow + ","); }
    if (sources != null && !sources.isEmpty()) { sb.append("sources:"); sb.append(sources + ","); }
    if (template != null && !template.isEmpty()) { sb.append("template:"); sb.append(template + ","); }
    if (types != null && !types.isEmpty()) { sb.append("types:"); sb.append(types); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationNestedImpl<N> extends AuthorizationSpecFluentImpl<KameletSpecFluent.AuthorizationNested<N>> implements KameletSpecFluent.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(AuthorizationSpec item) {
      this.builder = new AuthorizationSpecBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new AuthorizationSpecBuilder(this);
    }
    AuthorizationSpecBuilder builder;
    public N and() {
      return (N) KameletSpecFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class DefinitionNestedImpl<N> extends JSONSchemaPropsFluentImpl<KameletSpecFluent.DefinitionNested<N>> implements KameletSpecFluent.DefinitionNested<N>,Nested<N>{
    DefinitionNestedImpl(JSONSchemaProps item) {
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    DefinitionNestedImpl() {
      this.builder = new JSONSchemaPropsBuilder(this);
    }
    JSONSchemaPropsBuilder builder;
    public N and() {
      return (N) KameletSpecFluentImpl.this.withDefinition(builder.build());
    }
    public N endDefinition() {
      return and();
    }
    
  }
  
}