/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.MavenArtifact;
import io.fabric8.camelk.v1.MavenArtifactBuilder;
import io.fabric8.camelk.v1.MavenArtifactFluentImpl;
import io.fabric8.camelk.v1.MavenSpec;
import io.fabric8.camelk.v1.MavenSpecFluent;
import io.fabric8.camelk.v1.ValueSource;
import io.fabric8.camelk.v1.ValueSourceBuilder;
import io.fabric8.camelk.v1.ValueSourceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MavenSpecFluentImpl<A extends MavenSpecFluent<A>>
extends BaseFluent<A>
implements MavenSpecFluent<A> {
    private SecretKeySelector caSecret;
    private List<String> cliOptions = new ArrayList<String>();
    private ArrayList<MavenArtifactBuilder> extension = new ArrayList();
    private String localRepository;
    private Map<String, String> properties;
    private ValueSourceBuilder settings;
    private Duration timeout;

    public MavenSpecFluentImpl() {
    }

    public MavenSpecFluentImpl(MavenSpec instance) {
        this.withCaSecret(instance.getCaSecret());
        this.withCliOptions(instance.getCliOptions());
        this.withExtension(instance.getExtension());
        this.withLocalRepository(instance.getLocalRepository());
        this.withProperties(instance.getProperties());
        this.withSettings(instance.getSettings());
        this.withTimeout(instance.getTimeout());
    }

    @Override
    public SecretKeySelector getCaSecret() {
        return this.caSecret;
    }

    @Override
    public A withCaSecret(SecretKeySelector caSecret) {
        this.caSecret = caSecret;
        return (A)this;
    }

    @Override
    public Boolean hasCaSecret() {
        return this.caSecret != null;
    }

    @Override
    public A withNewCaSecret(String key, String name, Boolean optional) {
        return this.withCaSecret(new SecretKeySelector(key, name, optional));
    }

    @Override
    public A addToCliOptions(Integer index, String item) {
        if (this.cliOptions == null) {
            this.cliOptions = new ArrayList<String>();
        }
        this.cliOptions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCliOptions(Integer index, String item) {
        if (this.cliOptions == null) {
            this.cliOptions = new ArrayList<String>();
        }
        this.cliOptions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCliOptions(String ... items) {
        if (this.cliOptions == null) {
            this.cliOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.cliOptions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCliOptions(Collection<String> items) {
        if (this.cliOptions == null) {
            this.cliOptions = new ArrayList<String>();
        }
        for (String item : items) {
            this.cliOptions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCliOptions(String ... items) {
        for (String item : items) {
            if (this.cliOptions == null) continue;
            this.cliOptions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCliOptions(Collection<String> items) {
        for (String item : items) {
            if (this.cliOptions == null) continue;
            this.cliOptions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCliOptions() {
        return this.cliOptions;
    }

    @Override
    public String getCliOption(Integer index) {
        return this.cliOptions.get(index);
    }

    @Override
    public String getFirstCliOption() {
        return this.cliOptions.get(0);
    }

    @Override
    public String getLastCliOption() {
        return this.cliOptions.get(this.cliOptions.size() - 1);
    }

    @Override
    public String getMatchingCliOption(Predicate<String> predicate) {
        for (String item : this.cliOptions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCliOption(Predicate<String> predicate) {
        for (String item : this.cliOptions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCliOptions(List<String> cliOptions) {
        if (cliOptions != null) {
            this.cliOptions = new ArrayList<String>();
            for (String item : cliOptions) {
                this.addToCliOptions(item);
            }
        } else {
            this.cliOptions = null;
        }
        return (A)this;
    }

    @Override
    public A withCliOptions(String ... cliOptions) {
        if (this.cliOptions != null) {
            this.cliOptions.clear();
        }
        if (cliOptions != null) {
            for (String item : cliOptions) {
                this.addToCliOptions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCliOptions() {
        return this.cliOptions != null && !this.cliOptions.isEmpty();
    }

    @Override
    public A addToExtension(Integer index, MavenArtifact item) {
        if (this.extension == null) {
            this.extension = new ArrayList();
        }
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
        this._visitables.get((Object)"extension").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"extension").size(), builder);
        this.extension.add(index >= 0 ? index.intValue() : this.extension.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExtension(Integer index, MavenArtifact item) {
        if (this.extension == null) {
            this.extension = new ArrayList();
        }
        MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"extension").size()) {
            this._visitables.get((Object)"extension").add(builder);
        } else {
            this._visitables.get((Object)"extension").set(index, builder);
        }
        if (index < 0 || index >= this.extension.size()) {
            this.extension.add(builder);
        } else {
            this.extension.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExtension(MavenArtifact ... items) {
        if (this.extension == null) {
            this.extension = new ArrayList();
        }
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"extension").add(builder);
            this.extension.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtension(Collection<MavenArtifact> items) {
        if (this.extension == null) {
            this.extension = new ArrayList();
        }
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"extension").add(builder);
            this.extension.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtension(MavenArtifact ... items) {
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"extension").remove(builder);
            if (this.extension == null) continue;
            this.extension.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtension(Collection<MavenArtifact> items) {
        for (MavenArtifact item : items) {
            MavenArtifactBuilder builder = new MavenArtifactBuilder(item);
            this._visitables.get((Object)"extension").remove(builder);
            if (this.extension == null) continue;
            this.extension.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromExtension(Predicate<MavenArtifactBuilder> predicate) {
        if (this.extension == null) {
            return (A)this;
        }
        Iterator<MavenArtifactBuilder> each = this.extension.iterator();
        List visitables = this._visitables.get((Object)"extension");
        while (each.hasNext()) {
            MavenArtifactBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MavenArtifact> getExtension() {
        return this.extension != null ? MavenSpecFluentImpl.build(this.extension) : null;
    }

    @Override
    public List<MavenArtifact> buildExtension() {
        return this.extension != null ? MavenSpecFluentImpl.build(this.extension) : null;
    }

    @Override
    public MavenArtifact buildExtension(Integer index) {
        return this.extension.get(index).build();
    }

    @Override
    public MavenArtifact buildFirstExtension() {
        return this.extension.get(0).build();
    }

    @Override
    public MavenArtifact buildLastExtension() {
        return this.extension.get(this.extension.size() - 1).build();
    }

    @Override
    public MavenArtifact buildMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item : this.extension) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
        for (MavenArtifactBuilder item : this.extension) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExtension(List<MavenArtifact> extension) {
        if (this.extension != null) {
            this._visitables.get((Object)"extension").removeAll(this.extension);
        }
        if (extension != null) {
            this.extension = new ArrayList();
            for (MavenArtifact item : extension) {
                this.addToExtension(item);
            }
        } else {
            this.extension = null;
        }
        return (A)this;
    }

    @Override
    public A withExtension(MavenArtifact ... extension) {
        if (this.extension != null) {
            this.extension.clear();
        }
        if (extension != null) {
            for (MavenArtifact item : extension) {
                this.addToExtension(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtension() {
        return this.extension != null && !this.extension.isEmpty();
    }

    @Override
    public A addNewExtension(String artifactId, String groupId, String version) {
        return this.addToExtension(new MavenArtifact(artifactId, groupId, version));
    }

    @Override
    public MavenSpecFluent.ExtensionNested<A> addNewExtension() {
        return new ExtensionNestedImpl();
    }

    @Override
    public MavenSpecFluent.ExtensionNested<A> addNewExtensionLike(MavenArtifact item) {
        return new ExtensionNestedImpl(-1, item);
    }

    @Override
    public MavenSpecFluent.ExtensionNested<A> setNewExtensionLike(Integer index, MavenArtifact item) {
        return new ExtensionNestedImpl(index, item);
    }

    @Override
    public MavenSpecFluent.ExtensionNested<A> editExtension(Integer index) {
        if (this.extension.size() <= index) {
            throw new RuntimeException("Can't edit extension. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public MavenSpecFluent.ExtensionNested<A> editFirstExtension() {
        if (this.extension.size() == 0) {
            throw new RuntimeException("Can't edit first extension. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    @Override
    public MavenSpecFluent.ExtensionNested<A> editLastExtension() {
        int index = this.extension.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extension. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public MavenSpecFluent.ExtensionNested<A> editMatchingExtension(Predicate<MavenArtifactBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extension.size(); ++i) {
            if (!predicate.test(this.extension.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extension. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public String getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public A withLocalRepository(String localRepository) {
        this.localRepository = localRepository;
        return (A)this;
    }

    @Override
    public Boolean hasLocalRepository() {
        return this.localRepository != null;
    }

    @Override
    public A addToProperties(String key, String value) {
        if (this.properties == null && key != null && value != null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.properties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToProperties(Map<String, String> map) {
        if (this.properties == null && map != null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.properties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromProperties(String key) {
        if (this.properties == null) {
            return (A)this;
        }
        if (key != null && this.properties != null) {
            this.properties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromProperties(Map<String, String> map) {
        if (this.properties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.properties == null) continue;
                this.properties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public <K, V> A withProperties(Map<String, String> properties) {
        this.properties = properties == null ? null : new LinkedHashMap<String, String>(properties);
        return (A)this;
    }

    @Override
    public Boolean hasProperties() {
        return this.properties != null;
    }

    @Override
    @Deprecated
    public ValueSource getSettings() {
        return this.settings != null ? this.settings.build() : null;
    }

    @Override
    public ValueSource buildSettings() {
        return this.settings != null ? this.settings.build() : null;
    }

    @Override
    public A withSettings(ValueSource settings) {
        this._visitables.get((Object)"settings").remove(this.settings);
        if (settings != null) {
            this.settings = new ValueSourceBuilder(settings);
            this._visitables.get((Object)"settings").add(this.settings);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSettings() {
        return this.settings != null;
    }

    @Override
    public MavenSpecFluent.SettingsNested<A> withNewSettings() {
        return new SettingsNestedImpl();
    }

    @Override
    public MavenSpecFluent.SettingsNested<A> withNewSettingsLike(ValueSource item) {
        return new SettingsNestedImpl(item);
    }

    @Override
    public MavenSpecFluent.SettingsNested<A> editSettings() {
        return this.withNewSettingsLike(this.getSettings());
    }

    @Override
    public MavenSpecFluent.SettingsNested<A> editOrNewSettings() {
        return this.withNewSettingsLike(this.getSettings() != null ? this.getSettings() : new ValueSourceBuilder().build());
    }

    @Override
    public MavenSpecFluent.SettingsNested<A> editOrNewSettingsLike(ValueSource item) {
        return this.withNewSettingsLike(this.getSettings() != null ? this.getSettings() : item);
    }

    @Override
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public A withTimeout(Duration timeout) {
        this.timeout = timeout;
        return (A)this;
    }

    @Override
    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenSpecFluentImpl that = (MavenSpecFluentImpl)o;
        if (this.caSecret != null ? !this.caSecret.equals((Object)that.caSecret) : that.caSecret != null) {
            return false;
        }
        if (this.cliOptions != null ? !this.cliOptions.equals(that.cliOptions) : that.cliOptions != null) {
            return false;
        }
        if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
            return false;
        }
        if (this.localRepository != null ? !this.localRepository.equals(that.localRepository) : that.localRepository != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.settings != null ? !this.settings.equals(that.settings) : that.settings != null) {
            return false;
        }
        return !(this.timeout != null ? !this.timeout.equals((Object)that.timeout) : that.timeout != null);
    }

    public int hashCode() {
        return Objects.hash(this.caSecret, this.cliOptions, this.extension, this.localRepository, this.properties, this.settings, this.timeout, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caSecret != null) {
            sb.append("caSecret:");
            sb.append(this.caSecret + ",");
        }
        if (this.cliOptions != null && !this.cliOptions.isEmpty()) {
            sb.append("cliOptions:");
            sb.append(this.cliOptions + ",");
        }
        if (this.extension != null && !this.extension.isEmpty()) {
            sb.append("extension:");
            sb.append(this.extension + ",");
        }
        if (this.localRepository != null) {
            sb.append("localRepository:");
            sb.append(this.localRepository + ",");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties:");
            sb.append(this.properties + ",");
        }
        if (this.settings != null) {
            sb.append("settings:");
            sb.append(this.settings + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout);
        }
        sb.append("}");
        return sb.toString();
    }

    class SettingsNestedImpl<N>
    extends ValueSourceFluentImpl<MavenSpecFluent.SettingsNested<N>>
    implements MavenSpecFluent.SettingsNested<N>,
    Nested<N> {
        ValueSourceBuilder builder;

        SettingsNestedImpl(ValueSource item) {
            this.builder = new ValueSourceBuilder(this, item);
        }

        SettingsNestedImpl() {
            this.builder = new ValueSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)MavenSpecFluentImpl.this.withSettings(this.builder.build());
        }

        @Override
        public N endSettings() {
            return this.and();
        }
    }

    class ExtensionNestedImpl<N>
    extends MavenArtifactFluentImpl<MavenSpecFluent.ExtensionNested<N>>
    implements MavenSpecFluent.ExtensionNested<N>,
    Nested<N> {
        MavenArtifactBuilder builder;
        Integer index;

        ExtensionNestedImpl(Integer index, MavenArtifact item) {
            this.index = index;
            this.builder = new MavenArtifactBuilder(this, item);
        }

        ExtensionNestedImpl() {
            this.index = -1;
            this.builder = new MavenArtifactBuilder(this);
        }

        @Override
        public N and() {
            return (N)MavenSpecFluentImpl.this.setToExtension(this.index, this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }
}

