/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.CamelArtifact;
import io.fabric8.camelk.v1.CamelCatalogSpec;
import io.fabric8.camelk.v1.CamelCatalogSpecFluent;
import io.fabric8.camelk.v1.CamelLoader;
import io.fabric8.camelk.v1.RuntimeSpec;
import io.fabric8.camelk.v1.RuntimeSpecBuilder;
import io.fabric8.camelk.v1.RuntimeSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CamelCatalogSpecFluentImpl<A extends CamelCatalogSpecFluent<A>>
extends BaseFluent<A>
implements CamelCatalogSpecFluent<A> {
    private Map<String, CamelArtifact> artifacts;
    private Map<String, CamelLoader> loaders;
    private RuntimeSpecBuilder runtime;

    public CamelCatalogSpecFluentImpl() {
    }

    public CamelCatalogSpecFluentImpl(CamelCatalogSpec instance) {
        this.withArtifacts(instance.getArtifacts());
        this.withLoaders(instance.getLoaders());
        this.withRuntime(instance.getRuntime());
    }

    @Override
    public A addToArtifacts(String key, CamelArtifact value) {
        if (this.artifacts == null && key != null && value != null) {
            this.artifacts = new LinkedHashMap<String, CamelArtifact>();
        }
        if (key != null && value != null) {
            this.artifacts.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToArtifacts(Map<String, CamelArtifact> map) {
        if (this.artifacts == null && map != null) {
            this.artifacts = new LinkedHashMap<String, CamelArtifact>();
        }
        if (map != null) {
            this.artifacts.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromArtifacts(String key) {
        if (this.artifacts == null) {
            return (A)this;
        }
        if (key != null && this.artifacts != null) {
            this.artifacts.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromArtifacts(Map<String, CamelArtifact> map) {
        if (this.artifacts == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.artifacts == null) continue;
                this.artifacts.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, CamelArtifact> getArtifacts() {
        return this.artifacts;
    }

    @Override
    public <K, V> A withArtifacts(Map<String, CamelArtifact> artifacts) {
        this.artifacts = artifacts == null ? null : new LinkedHashMap<String, CamelArtifact>(artifacts);
        return (A)this;
    }

    @Override
    public Boolean hasArtifacts() {
        return this.artifacts != null;
    }

    @Override
    public A addToLoaders(String key, CamelLoader value) {
        if (this.loaders == null && key != null && value != null) {
            this.loaders = new LinkedHashMap<String, CamelLoader>();
        }
        if (key != null && value != null) {
            this.loaders.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLoaders(Map<String, CamelLoader> map) {
        if (this.loaders == null && map != null) {
            this.loaders = new LinkedHashMap<String, CamelLoader>();
        }
        if (map != null) {
            this.loaders.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLoaders(String key) {
        if (this.loaders == null) {
            return (A)this;
        }
        if (key != null && this.loaders != null) {
            this.loaders.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLoaders(Map<String, CamelLoader> map) {
        if (this.loaders == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.loaders == null) continue;
                this.loaders.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, CamelLoader> getLoaders() {
        return this.loaders;
    }

    @Override
    public <K, V> A withLoaders(Map<String, CamelLoader> loaders) {
        this.loaders = loaders == null ? null : new LinkedHashMap<String, CamelLoader>(loaders);
        return (A)this;
    }

    @Override
    public Boolean hasLoaders() {
        return this.loaders != null;
    }

    @Override
    @Deprecated
    public RuntimeSpec getRuntime() {
        return this.runtime != null ? this.runtime.build() : null;
    }

    @Override
    public RuntimeSpec buildRuntime() {
        return this.runtime != null ? this.runtime.build() : null;
    }

    @Override
    public A withRuntime(RuntimeSpec runtime) {
        this._visitables.get((Object)"runtime").remove(this.runtime);
        if (runtime != null) {
            this.runtime = new RuntimeSpecBuilder(runtime);
            this._visitables.get((Object)"runtime").add(this.runtime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRuntime() {
        return this.runtime != null;
    }

    @Override
    public CamelCatalogSpecFluent.RuntimeNested<A> withNewRuntime() {
        return new RuntimeNestedImpl();
    }

    @Override
    public CamelCatalogSpecFluent.RuntimeNested<A> withNewRuntimeLike(RuntimeSpec item) {
        return new RuntimeNestedImpl(item);
    }

    @Override
    public CamelCatalogSpecFluent.RuntimeNested<A> editRuntime() {
        return this.withNewRuntimeLike(this.getRuntime());
    }

    @Override
    public CamelCatalogSpecFluent.RuntimeNested<A> editOrNewRuntime() {
        return this.withNewRuntimeLike(this.getRuntime() != null ? this.getRuntime() : new RuntimeSpecBuilder().build());
    }

    @Override
    public CamelCatalogSpecFluent.RuntimeNested<A> editOrNewRuntimeLike(RuntimeSpec item) {
        return this.withNewRuntimeLike(this.getRuntime() != null ? this.getRuntime() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CamelCatalogSpecFluentImpl that = (CamelCatalogSpecFluentImpl)o;
        if (this.artifacts != null ? !this.artifacts.equals(that.artifacts) : that.artifacts != null) {
            return false;
        }
        if (this.loaders != null ? !this.loaders.equals(that.loaders) : that.loaders != null) {
            return false;
        }
        return !(this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null);
    }

    public int hashCode() {
        return Objects.hash(this.artifacts, this.loaders, this.runtime, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.artifacts != null && !this.artifacts.isEmpty()) {
            sb.append("artifacts:");
            sb.append(this.artifacts + ",");
        }
        if (this.loaders != null && !this.loaders.isEmpty()) {
            sb.append("loaders:");
            sb.append(this.loaders + ",");
        }
        if (this.runtime != null) {
            sb.append("runtime:");
            sb.append(this.runtime);
        }
        sb.append("}");
        return sb.toString();
    }

    class RuntimeNestedImpl<N>
    extends RuntimeSpecFluentImpl<CamelCatalogSpecFluent.RuntimeNested<N>>
    implements CamelCatalogSpecFluent.RuntimeNested<N>,
    Nested<N> {
        RuntimeSpecBuilder builder;

        RuntimeNestedImpl(RuntimeSpec item) {
            this.builder = new RuntimeSpecBuilder(this, item);
        }

        RuntimeNestedImpl() {
            this.builder = new RuntimeSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)CamelCatalogSpecFluentImpl.this.withRuntime(this.builder.build());
        }

        @Override
        public N endRuntime() {
            return this.and();
        }
    }
}

