/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.BuilderTask;
import io.fabric8.camelk.v1.BuilderTaskFluent;
import io.fabric8.camelk.v1.MavenBuildSpec;
import io.fabric8.camelk.v1.MavenBuildSpecBuilder;
import io.fabric8.camelk.v1.MavenBuildSpecFluentImpl;
import io.fabric8.camelk.v1.ResourceSpec;
import io.fabric8.camelk.v1.ResourceSpecBuilder;
import io.fabric8.camelk.v1.ResourceSpecFluentImpl;
import io.fabric8.camelk.v1.RuntimeSpec;
import io.fabric8.camelk.v1.RuntimeSpecBuilder;
import io.fabric8.camelk.v1.RuntimeSpecFluentImpl;
import io.fabric8.camelk.v1.SourceSpec;
import io.fabric8.camelk.v1.SourceSpecBuilder;
import io.fabric8.camelk.v1.SourceSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BuilderTaskFluentImpl<A extends BuilderTaskFluent<A>>
extends BaseFluent<A>
implements BuilderTaskFluent<A> {
    private String baseImage;
    private String buildDir;
    private List<String> dependencies = new ArrayList<String>();
    private MavenBuildSpecBuilder maven;
    private String name;
    private ArrayList<ResourceSpecBuilder> resources = new ArrayList();
    private RuntimeSpecBuilder runtime;
    private ArrayList<SourceSpecBuilder> sources = new ArrayList();
    private List<String> steps = new ArrayList<String>();

    public BuilderTaskFluentImpl() {
    }

    public BuilderTaskFluentImpl(BuilderTask instance) {
        this.withBaseImage(instance.getBaseImage());
        this.withBuildDir(instance.getBuildDir());
        this.withDependencies(instance.getDependencies());
        this.withMaven(instance.getMaven());
        this.withName(instance.getName());
        this.withResources(instance.getResources());
        this.withRuntime(instance.getRuntime());
        this.withSources(instance.getSources());
        this.withSteps(instance.getSteps());
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)this;
    }

    @Override
    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    @Override
    public String getBuildDir() {
        return this.buildDir;
    }

    @Override
    public A withBuildDir(String buildDir) {
        this.buildDir = buildDir;
        return (A)this;
    }

    @Override
    public Boolean hasBuildDir() {
        return this.buildDir != null;
    }

    @Override
    public A addToDependencies(Integer index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDependencies(Integer index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDependencies(String ... items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDependencies(Collection<String> items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getDependency(Integer index) {
        return this.dependencies.get(index);
    }

    @Override
    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    @Override
    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    @Override
    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDependencies(List<String> dependencies) {
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)this;
    }

    @Override
    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    @Override
    @Deprecated
    public MavenBuildSpec getMaven() {
        return this.maven != null ? this.maven.build() : null;
    }

    @Override
    public MavenBuildSpec buildMaven() {
        return this.maven != null ? this.maven.build() : null;
    }

    @Override
    public A withMaven(MavenBuildSpec maven) {
        this._visitables.get((Object)"maven").remove(this.maven);
        if (maven != null) {
            this.maven = new MavenBuildSpecBuilder(maven);
            this._visitables.get((Object)"maven").add(this.maven);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMaven() {
        return this.maven != null;
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> withNewMaven() {
        return new MavenNestedImpl();
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> withNewMavenLike(MavenBuildSpec item) {
        return new MavenNestedImpl(item);
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> editMaven() {
        return this.withNewMavenLike(this.getMaven());
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> editOrNewMaven() {
        return this.withNewMavenLike(this.getMaven() != null ? this.getMaven() : new MavenBuildSpecBuilder().build());
    }

    @Override
    public BuilderTaskFluent.MavenNested<A> editOrNewMavenLike(MavenBuildSpec item) {
        return this.withNewMavenLike(this.getMaven() != null ? this.getMaven() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToResources(Integer index, ResourceSpec item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        this._visitables.get((Object)"resources").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"resources").size(), builder);
        this.resources.add(index >= 0 ? index.intValue() : this.resources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResources(Integer index, ResourceSpec item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"resources").size()) {
            this._visitables.get((Object)"resources").add(builder);
        } else {
            this._visitables.get((Object)"resources").set(index, builder);
        }
        if (index < 0 || index >= this.resources.size()) {
            this.resources.add(builder);
        } else {
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResources(ResourceSpec ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<ResourceSpec> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(ResourceSpec ... items) {
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<ResourceSpec> items) {
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<ResourceSpecBuilder> each = this.resources.iterator();
        List visitables = this._visitables.get((Object)"resources");
        while (each.hasNext()) {
            ResourceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResourceSpec> getResources() {
        return this.resources != null ? BuilderTaskFluentImpl.build(this.resources) : null;
    }

    @Override
    public List<ResourceSpec> buildResources() {
        return this.resources != null ? BuilderTaskFluentImpl.build(this.resources) : null;
    }

    @Override
    public ResourceSpec buildResource(Integer index) {
        return this.resources.get(index).build();
    }

    @Override
    public ResourceSpec buildFirstResource() {
        return this.resources.get(0).build();
    }

    @Override
    public ResourceSpec buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    @Override
    public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<ResourceSpec> resources) {
        if (this.resources != null) {
            this._visitables.get((Object)"resources").removeAll(this.resources);
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (ResourceSpec item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(ResourceSpec ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (ResourceSpec item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item) {
        return new ResourcesNestedImpl(-1, item);
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> setNewResourceLike(Integer index, ResourceSpec item) {
        return new ResourcesNestedImpl(index, item);
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> editResource(Integer index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public BuilderTaskFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    @Deprecated
    public RuntimeSpec getRuntime() {
        return this.runtime != null ? this.runtime.build() : null;
    }

    @Override
    public RuntimeSpec buildRuntime() {
        return this.runtime != null ? this.runtime.build() : null;
    }

    @Override
    public A withRuntime(RuntimeSpec runtime) {
        this._visitables.get((Object)"runtime").remove(this.runtime);
        if (runtime != null) {
            this.runtime = new RuntimeSpecBuilder(runtime);
            this._visitables.get((Object)"runtime").add(this.runtime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRuntime() {
        return this.runtime != null;
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> withNewRuntime() {
        return new RuntimeNestedImpl();
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> withNewRuntimeLike(RuntimeSpec item) {
        return new RuntimeNestedImpl(item);
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> editRuntime() {
        return this.withNewRuntimeLike(this.getRuntime());
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> editOrNewRuntime() {
        return this.withNewRuntimeLike(this.getRuntime() != null ? this.getRuntime() : new RuntimeSpecBuilder().build());
    }

    @Override
    public BuilderTaskFluent.RuntimeNested<A> editOrNewRuntimeLike(RuntimeSpec item) {
        return this.withNewRuntimeLike(this.getRuntime() != null ? this.getRuntime() : item);
    }

    @Override
    public A addToSources(Integer index, SourceSpec item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        this._visitables.get((Object)"sources").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"sources").size(), builder);
        this.sources.add(index >= 0 ? index.intValue() : this.sources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSources(Integer index, SourceSpec item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"sources").size()) {
            this._visitables.get((Object)"sources").add(builder);
        } else {
            this._visitables.get((Object)"sources").set(index, builder);
        }
        if (index < 0 || index >= this.sources.size()) {
            this.sources.add(builder);
        } else {
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSources(SourceSpec ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSources(Collection<SourceSpec> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSources(SourceSpec ... items) {
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSources(Collection<SourceSpec> items) {
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"sources").remove(builder);
            if (this.sources == null) continue;
            this.sources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<SourceSpecBuilder> each = this.sources.iterator();
        List visitables = this._visitables.get((Object)"sources");
        while (each.hasNext()) {
            SourceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SourceSpec> getSources() {
        return this.sources != null ? BuilderTaskFluentImpl.build(this.sources) : null;
    }

    @Override
    public List<SourceSpec> buildSources() {
        return this.sources != null ? BuilderTaskFluentImpl.build(this.sources) : null;
    }

    @Override
    public SourceSpec buildSource(Integer index) {
        return this.sources.get(index).build();
    }

    @Override
    public SourceSpec buildFirstSource() {
        return this.sources.get(0).build();
    }

    @Override
    public SourceSpec buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    @Override
    public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSources(List<SourceSpec> sources) {
        if (this.sources != null) {
            this._visitables.get((Object)"sources").removeAll(this.sources);
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (SourceSpec item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    @Override
    public A withSources(SourceSpec ... sources) {
        if (this.sources != null) {
            this.sources.clear();
        }
        if (sources != null) {
            for (SourceSpec item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> addNewSourceLike(SourceSpec item) {
        return new SourcesNestedImpl(-1, item);
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> setNewSourceLike(Integer index, SourceSpec item) {
        return new SourcesNestedImpl(index, item);
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> editSource(Integer index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public BuilderTaskFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public A addToSteps(Integer index, String item) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        this.steps.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSteps(Integer index, String item) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        this.steps.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSteps(String ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        for (String item : items) {
            this.steps.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSteps(Collection<String> items) {
        if (this.steps == null) {
            this.steps = new ArrayList<String>();
        }
        for (String item : items) {
            this.steps.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSteps(String ... items) {
        for (String item : items) {
            if (this.steps == null) continue;
            this.steps.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSteps(Collection<String> items) {
        for (String item : items) {
            if (this.steps == null) continue;
            this.steps.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSteps() {
        return this.steps;
    }

    @Override
    public String getStep(Integer index) {
        return this.steps.get(index);
    }

    @Override
    public String getFirstStep() {
        return this.steps.get(0);
    }

    @Override
    public String getLastStep() {
        return this.steps.get(this.steps.size() - 1);
    }

    @Override
    public String getMatchingStep(Predicate<String> predicate) {
        for (String item : this.steps) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStep(Predicate<String> predicate) {
        for (String item : this.steps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSteps(List<String> steps) {
        if (steps != null) {
            this.steps = new ArrayList<String>();
            for (String item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = null;
        }
        return (A)this;
    }

    @Override
    public A withSteps(String ... steps) {
        if (this.steps != null) {
            this.steps.clear();
        }
        if (steps != null) {
            for (String item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuilderTaskFluentImpl that = (BuilderTaskFluentImpl)o;
        if (this.baseImage != null ? !this.baseImage.equals(that.baseImage) : that.baseImage != null) {
            return false;
        }
        if (this.buildDir != null ? !this.buildDir.equals(that.buildDir) : that.buildDir != null) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) {
            return false;
        }
        if (this.maven != null ? !this.maven.equals(that.maven) : that.maven != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.runtime != null ? !this.runtime.equals(that.runtime) : that.runtime != null) {
            return false;
        }
        if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) {
            return false;
        }
        return !(this.steps != null ? !this.steps.equals(that.steps) : that.steps != null);
    }

    public int hashCode() {
        return Objects.hash(this.baseImage, this.buildDir, this.dependencies, this.maven, this.name, this.resources, this.runtime, this.sources, this.steps, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.buildDir != null) {
            sb.append("buildDir:");
            sb.append(this.buildDir + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.maven != null) {
            sb.append("maven:");
            sb.append(this.maven + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.runtime != null) {
            sb.append("runtime:");
            sb.append(this.runtime + ",");
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources + ",");
        }
        if (this.steps != null && !this.steps.isEmpty()) {
            sb.append("steps:");
            sb.append(this.steps);
        }
        sb.append("}");
        return sb.toString();
    }

    class SourcesNestedImpl<N>
    extends SourceSpecFluentImpl<BuilderTaskFluent.SourcesNested<N>>
    implements BuilderTaskFluent.SourcesNested<N>,
    Nested<N> {
        SourceSpecBuilder builder;
        Integer index;

        SourcesNestedImpl(Integer index, SourceSpec item) {
            this.index = index;
            this.builder = new SourceSpecBuilder(this, item);
        }

        SourcesNestedImpl() {
            this.index = -1;
            this.builder = new SourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.setToSources(this.index, this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    class RuntimeNestedImpl<N>
    extends RuntimeSpecFluentImpl<BuilderTaskFluent.RuntimeNested<N>>
    implements BuilderTaskFluent.RuntimeNested<N>,
    Nested<N> {
        RuntimeSpecBuilder builder;

        RuntimeNestedImpl(RuntimeSpec item) {
            this.builder = new RuntimeSpecBuilder(this, item);
        }

        RuntimeNestedImpl() {
            this.builder = new RuntimeSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.withRuntime(this.builder.build());
        }

        @Override
        public N endRuntime() {
            return this.and();
        }
    }

    class ResourcesNestedImpl<N>
    extends ResourceSpecFluentImpl<BuilderTaskFluent.ResourcesNested<N>>
    implements BuilderTaskFluent.ResourcesNested<N>,
    Nested<N> {
        ResourceSpecBuilder builder;
        Integer index;

        ResourcesNestedImpl(Integer index, ResourceSpec item) {
            this.index = index;
            this.builder = new ResourceSpecBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.index = -1;
            this.builder = new ResourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.setToResources(this.index, this.builder.build());
        }

        @Override
        public N endResource() {
            return this.and();
        }
    }

    class MavenNestedImpl<N>
    extends MavenBuildSpecFluentImpl<BuilderTaskFluent.MavenNested<N>>
    implements BuilderTaskFluent.MavenNested<N>,
    Nested<N> {
        MavenBuildSpecBuilder builder;

        MavenNestedImpl(MavenBuildSpec item) {
            this.builder = new MavenBuildSpecBuilder(this, item);
        }

        MavenNestedImpl() {
            this.builder = new MavenBuildSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuilderTaskFluentImpl.this.withMaven(this.builder.build());
        }

        @Override
        public N endMaven() {
            return this.and();
        }
    }
}

