/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.BuildahTask;
import io.fabric8.camelk.v1.BuildahTaskFluent;
import io.fabric8.camelk.v1.RegistrySpec;
import io.fabric8.camelk.v1.RegistrySpecBuilder;
import io.fabric8.camelk.v1.RegistrySpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class BuildahTaskFluentImpl<A extends BuildahTaskFluent<A>>
extends BaseFluent<A>
implements BuildahTaskFluent<A> {
    private String baseImage;
    private String contextDir;
    private String image;
    private String name;
    private RegistrySpecBuilder registry;
    private Boolean verbose;

    public BuildahTaskFluentImpl() {
    }

    public BuildahTaskFluentImpl(BuildahTask instance) {
        this.withBaseImage(instance.getBaseImage());
        this.withContextDir(instance.getContextDir());
        this.withImage(instance.getImage());
        this.withName(instance.getName());
        this.withRegistry(instance.getRegistry());
        this.withVerbose(instance.getVerbose());
    }

    @Override
    public String getBaseImage() {
        return this.baseImage;
    }

    @Override
    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)this;
    }

    @Override
    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    @Override
    public String getContextDir() {
        return this.contextDir;
    }

    @Override
    public A withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (A)this;
    }

    @Override
    public Boolean hasContextDir() {
        return this.contextDir != null;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public RegistrySpec getRegistry() {
        return this.registry != null ? this.registry.build() : null;
    }

    @Override
    public RegistrySpec buildRegistry() {
        return this.registry != null ? this.registry.build() : null;
    }

    @Override
    public A withRegistry(RegistrySpec registry) {
        this._visitables.get((Object)"registry").remove(this.registry);
        if (registry != null) {
            this.registry = new RegistrySpecBuilder(registry);
            this._visitables.get((Object)"registry").add(this.registry);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRegistry() {
        return this.registry != null;
    }

    @Override
    public A withNewRegistry(String address, String ca, Boolean insecure, String organization, String secret) {
        return this.withRegistry(new RegistrySpec(address, ca, insecure, organization, secret));
    }

    @Override
    public BuildahTaskFluent.RegistryNested<A> withNewRegistry() {
        return new RegistryNestedImpl();
    }

    @Override
    public BuildahTaskFluent.RegistryNested<A> withNewRegistryLike(RegistrySpec item) {
        return new RegistryNestedImpl(item);
    }

    @Override
    public BuildahTaskFluent.RegistryNested<A> editRegistry() {
        return this.withNewRegistryLike(this.getRegistry());
    }

    @Override
    public BuildahTaskFluent.RegistryNested<A> editOrNewRegistry() {
        return this.withNewRegistryLike(this.getRegistry() != null ? this.getRegistry() : new RegistrySpecBuilder().build());
    }

    @Override
    public BuildahTaskFluent.RegistryNested<A> editOrNewRegistryLike(RegistrySpec item) {
        return this.withNewRegistryLike(this.getRegistry() != null ? this.getRegistry() : item);
    }

    @Override
    public Boolean getVerbose() {
        return this.verbose;
    }

    @Override
    public A withVerbose(Boolean verbose) {
        this.verbose = verbose;
        return (A)this;
    }

    @Override
    public Boolean hasVerbose() {
        return this.verbose != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildahTaskFluentImpl that = (BuildahTaskFluentImpl)o;
        if (this.baseImage != null ? !this.baseImage.equals(that.baseImage) : that.baseImage != null) {
            return false;
        }
        if (this.contextDir != null ? !this.contextDir.equals(that.contextDir) : that.contextDir != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.registry != null ? !this.registry.equals(that.registry) : that.registry != null) {
            return false;
        }
        return !(this.verbose != null ? !this.verbose.equals(that.verbose) : that.verbose != null);
    }

    public int hashCode() {
        return Objects.hash(this.baseImage, this.contextDir, this.image, this.name, this.registry, this.verbose, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.contextDir != null) {
            sb.append("contextDir:");
            sb.append(this.contextDir + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.registry != null) {
            sb.append("registry:");
            sb.append(this.registry + ",");
        }
        if (this.verbose != null) {
            sb.append("verbose:");
            sb.append(this.verbose);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withVerbose() {
        return this.withVerbose(true);
    }

    class RegistryNestedImpl<N>
    extends RegistrySpecFluentImpl<BuildahTaskFluent.RegistryNested<N>>
    implements BuildahTaskFluent.RegistryNested<N>,
    Nested<N> {
        RegistrySpecBuilder builder;

        RegistryNestedImpl(RegistrySpec item) {
            this.builder = new RegistrySpecBuilder(this, item);
        }

        RegistryNestedImpl() {
            this.builder = new RegistrySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildahTaskFluentImpl.this.withRegistry(this.builder.build());
        }

        @Override
        public N endRegistry() {
            return this.and();
        }
    }
}

