package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JSONSchemaPropsBuilder extends JSONSchemaPropsFluentImpl<JSONSchemaPropsBuilder> implements VisitableBuilder<JSONSchemaProps,io.fabric8.camelk.v1alpha1.JSONSchemaPropsBuilder>{
  public JSONSchemaPropsBuilder() {
    this(false);
  }
  public JSONSchemaPropsBuilder(Boolean validationEnabled) {
    this(new JSONSchemaProps(), validationEnabled);
  }
  public JSONSchemaPropsBuilder(io.fabric8.camelk.v1alpha1.JSONSchemaPropsFluent<?> fluent) {
    this(fluent, false);
  }
  public JSONSchemaPropsBuilder(io.fabric8.camelk.v1alpha1.JSONSchemaPropsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new JSONSchemaProps(), validationEnabled);
  }
  public JSONSchemaPropsBuilder(io.fabric8.camelk.v1alpha1.JSONSchemaPropsFluent<?> fluent,io.fabric8.camelk.v1alpha1.JSONSchemaProps instance) {
    this(fluent, instance, false);
  }
  public JSONSchemaPropsBuilder(io.fabric8.camelk.v1alpha1.JSONSchemaPropsFluent<?> fluent,io.fabric8.camelk.v1alpha1.JSONSchemaProps instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSchema(instance.get$schema()); 
    fluent.withDescription(instance.getDescription()); 
    fluent.withExample(instance.getExample()); 
    fluent.withExternalDocs(instance.getExternalDocs()); 
    fluent.withId(instance.getId()); 
    fluent.withProperties(instance.getProperties()); 
    fluent.withRequired(instance.getRequired()); 
    fluent.withTitle(instance.getTitle()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public JSONSchemaPropsBuilder(io.fabric8.camelk.v1alpha1.JSONSchemaProps instance) {
    this(instance,false);
  }
  public JSONSchemaPropsBuilder(io.fabric8.camelk.v1alpha1.JSONSchemaProps instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withSchema(instance.get$schema()); 
    this.withDescription(instance.getDescription()); 
    this.withExample(instance.getExample()); 
    this.withExternalDocs(instance.getExternalDocs()); 
    this.withId(instance.getId()); 
    this.withProperties(instance.getProperties()); 
    this.withRequired(instance.getRequired()); 
    this.withTitle(instance.getTitle()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.camelk.v1alpha1.JSONSchemaPropsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.camelk.v1alpha1.JSONSchemaProps build() {
    JSONSchemaProps buildable = new JSONSchemaProps(fluent.getSchema(),fluent.getDescription(),fluent.getExample(),fluent.getExternalDocs(),fluent.getId(),fluent.getProperties(),fluent.getRequired(),fluent.getTitle(),fluent.getType());
    return buildable;
  }
  
}