/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.ConfigurationSpec;
import io.fabric8.camelk.v1.ConfigurationSpecBuilder;
import io.fabric8.camelk.v1.ConfigurationSpecFluentImpl;
import io.fabric8.camelk.v1.Failure;
import io.fabric8.camelk.v1.FailureBuilder;
import io.fabric8.camelk.v1.FailureFluentImpl;
import io.fabric8.camelk.v1.IntegrationCondition;
import io.fabric8.camelk.v1.IntegrationConditionBuilder;
import io.fabric8.camelk.v1.IntegrationConditionFluentImpl;
import io.fabric8.camelk.v1.IntegrationStatus;
import io.fabric8.camelk.v1.IntegrationStatusFluent;
import io.fabric8.camelk.v1.ResourceSpec;
import io.fabric8.camelk.v1.ResourceSpecBuilder;
import io.fabric8.camelk.v1.ResourceSpecFluentImpl;
import io.fabric8.camelk.v1.SourceSpec;
import io.fabric8.camelk.v1.SourceSpecBuilder;
import io.fabric8.camelk.v1.SourceSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IntegrationStatusFluentImpl<A extends IntegrationStatusFluent<A>>
extends BaseFluent<A>
implements IntegrationStatusFluent<A> {
    private List<String> capabilities;
    private List<IntegrationConditionBuilder> conditions;
    private List<ConfigurationSpecBuilder> configuration;
    private List<String> dependencies;
    private String digest;
    private FailureBuilder failure;
    private List<ResourceSpecBuilder> generatedResources;
    private List<SourceSpecBuilder> generatedSources;
    private String image;
    private String kit;
    private String lastInitTimestamp;
    private String phase;
    private String platform;
    private String profile;
    private Integer replicas;
    private String runtimeProvider;
    private String runtimeVersion;
    private String selector;
    private String version;

    public IntegrationStatusFluentImpl() {
    }

    public IntegrationStatusFluentImpl(IntegrationStatus instance) {
        this.withCapabilities(instance.getCapabilities());
        this.withConditions(instance.getConditions());
        this.withConfiguration(instance.getConfiguration());
        this.withDependencies(instance.getDependencies());
        this.withDigest(instance.getDigest());
        this.withFailure(instance.getFailure());
        this.withGeneratedResources(instance.getGeneratedResources());
        this.withGeneratedSources(instance.getGeneratedSources());
        this.withImage(instance.getImage());
        this.withKit(instance.getKit());
        this.withLastInitTimestamp(instance.getLastInitTimestamp());
        this.withPhase(instance.getPhase());
        this.withPlatform(instance.getPlatform());
        this.withProfile(instance.getProfile());
        this.withReplicas(instance.getReplicas());
        this.withRuntimeProvider(instance.getRuntimeProvider());
        this.withRuntimeVersion(instance.getRuntimeVersion());
        this.withSelector(instance.getSelector());
        this.withVersion(instance.getVersion());
    }

    @Override
    public A addToCapabilities(Integer index, String item) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        this.capabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCapabilities(Integer index, String item) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        this.capabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCapabilities(String ... items) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.capabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCapabilities(Collection<String> items) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.capabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapabilities(String ... items) {
        for (String item : items) {
            if (this.capabilities == null) continue;
            this.capabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCapabilities(Collection<String> items) {
        for (String item : items) {
            if (this.capabilities == null) continue;
            this.capabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public String getCapability(Integer index) {
        return this.capabilities.get(index);
    }

    @Override
    public String getFirstCapability() {
        return this.capabilities.get(0);
    }

    @Override
    public String getLastCapability() {
        return this.capabilities.get(this.capabilities.size() - 1);
    }

    @Override
    public String getMatchingCapability(Predicate<String> predicate) {
        for (String item : this.capabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCapability(Predicate<String> predicate) {
        for (String item : this.capabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCapabilities(List<String> capabilities) {
        if (capabilities != null) {
            this.capabilities = new ArrayList<String>();
            for (String item : capabilities) {
                this.addToCapabilities(item);
            }
        } else {
            this.capabilities = null;
        }
        return (A)this;
    }

    @Override
    public A withCapabilities(String ... capabilities) {
        if (this.capabilities != null) {
            this.capabilities.clear();
        }
        if (capabilities != null) {
            for (String item : capabilities) {
                this.addToCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCapabilities() {
        return this.capabilities != null && !this.capabilities.isEmpty();
    }

    @Override
    public A addNewCapability(String arg0) {
        return this.addToCapabilities(new String(arg0));
    }

    @Override
    public A addToConditions(Integer index, IntegrationCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IntegrationConditionBuilder>();
        }
        IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, IntegrationCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IntegrationConditionBuilder>();
        }
        IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(IntegrationCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IntegrationConditionBuilder>();
        }
        for (IntegrationCondition item : items) {
            IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<IntegrationCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IntegrationConditionBuilder>();
        }
        for (IntegrationCondition item : items) {
            IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(IntegrationCondition ... items) {
        for (IntegrationCondition item : items) {
            IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<IntegrationCondition> items) {
        for (IntegrationCondition item : items) {
            IntegrationConditionBuilder builder = new IntegrationConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<IntegrationConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<IntegrationConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            IntegrationConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IntegrationCondition> getConditions() {
        return IntegrationStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<IntegrationCondition> buildConditions() {
        return IntegrationStatusFluentImpl.build(this.conditions);
    }

    @Override
    public IntegrationCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public IntegrationCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public IntegrationCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public IntegrationCondition buildMatchingCondition(Predicate<IntegrationConditionBuilder> predicate) {
        for (IntegrationConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<IntegrationConditionBuilder> predicate) {
        for (IntegrationConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<IntegrationCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<IntegrationConditionBuilder>();
            for (IntegrationCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(IntegrationCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (IntegrationCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public IntegrationStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public IntegrationStatusFluent.ConditionsNested<A> addNewConditionLike(IntegrationCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public IntegrationStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, IntegrationCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public IntegrationStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public IntegrationStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public IntegrationStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public IntegrationStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IntegrationConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToConfiguration(Integer index, ConfigurationSpec item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
        }
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        this._visitables.get((Object)"configuration").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"configuration").size(), builder);
        this.configuration.add(index >= 0 ? index.intValue() : this.configuration.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConfiguration(Integer index, ConfigurationSpec item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
        }
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"configuration").size()) {
            this._visitables.get((Object)"configuration").add(builder);
        } else {
            this._visitables.get((Object)"configuration").set(index, builder);
        }
        if (index < 0 || index >= this.configuration.size()) {
            this.configuration.add(builder);
        } else {
            this.configuration.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConfiguration(ConfigurationSpec ... items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
        }
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
        }
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfiguration(ConfigurationSpec ... items) {
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").remove(builder);
            if (this.configuration == null) continue;
            this.configuration.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").remove(builder);
            if (this.configuration == null) continue;
            this.configuration.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        if (this.configuration == null) {
            return (A)this;
        }
        Iterator<ConfigurationSpecBuilder> each = this.configuration.iterator();
        List visitables = this._visitables.get((Object)"configuration");
        while (each.hasNext()) {
            ConfigurationSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ConfigurationSpec> getConfiguration() {
        return IntegrationStatusFluentImpl.build(this.configuration);
    }

    @Override
    public List<ConfigurationSpec> buildConfiguration() {
        return IntegrationStatusFluentImpl.build(this.configuration);
    }

    @Override
    public ConfigurationSpec buildConfiguration(Integer index) {
        return this.configuration.get(index).build();
    }

    @Override
    public ConfigurationSpec buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    @Override
    public ConfigurationSpec buildLastConfiguration() {
        return this.configuration.get(this.configuration.size() - 1).build();
    }

    @Override
    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConfiguration(List<ConfigurationSpec> configuration) {
        if (this.configuration != null) {
            this._visitables.get((Object)"configuration").removeAll(this.configuration);
        }
        if (configuration != null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
            for (ConfigurationSpec item : configuration) {
                this.addToConfiguration(item);
            }
        } else {
            this.configuration = null;
        }
        return (A)this;
    }

    @Override
    public A withConfiguration(ConfigurationSpec ... configuration) {
        if (this.configuration != null) {
            this.configuration.clear();
        }
        if (configuration != null) {
            for (ConfigurationSpec item : configuration) {
                this.addToConfiguration(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfiguration() {
        return this.configuration != null && !this.configuration.isEmpty();
    }

    @Override
    public A addNewConfiguration(String type, String value) {
        return this.addToConfiguration(new ConfigurationSpec(type, value));
    }

    @Override
    public IntegrationStatusFluent.ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    @Override
    public IntegrationStatusFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
        return new ConfigurationNestedImpl(-1, item);
    }

    @Override
    public IntegrationStatusFluent.ConfigurationNested<A> setNewConfigurationLike(Integer index, ConfigurationSpec item) {
        return new ConfigurationNestedImpl(index, item);
    }

    @Override
    public IntegrationStatusFluent.ConfigurationNested<A> editConfiguration(Integer index) {
        if (this.configuration.size() <= index) {
            throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    @Override
    public IntegrationStatusFluent.ConfigurationNested<A> editFirstConfiguration() {
        if (this.configuration.size() == 0) {
            throw new RuntimeException("Can't edit first configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(0, this.buildConfiguration(0));
    }

    @Override
    public IntegrationStatusFluent.ConfigurationNested<A> editLastConfiguration() {
        int index = this.configuration.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    @Override
    public IntegrationStatusFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configuration.size(); ++i) {
            if (!predicate.test(this.configuration.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configuration. No match found.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    @Override
    public A addToDependencies(Integer index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDependencies(Integer index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDependencies(String ... items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDependencies(Collection<String> items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getDependency(Integer index) {
        return this.dependencies.get(index);
    }

    @Override
    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    @Override
    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    @Override
    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDependencies(List<String> dependencies) {
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)this;
    }

    @Override
    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    @Override
    public A addNewDependency(String arg0) {
        return this.addToDependencies(new String(arg0));
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public A withDigest(String digest) {
        this.digest = digest;
        return (A)this;
    }

    @Override
    public Boolean hasDigest() {
        return this.digest != null;
    }

    @Override
    @Deprecated
    public A withNewDigest(String arg0) {
        return this.withDigest(new String(arg0));
    }

    @Override
    @Deprecated
    public Failure getFailure() {
        return this.failure != null ? this.failure.build() : null;
    }

    @Override
    public Failure buildFailure() {
        return this.failure != null ? this.failure.build() : null;
    }

    @Override
    public A withFailure(Failure failure) {
        this._visitables.get((Object)"failure").remove(this.failure);
        if (failure != null) {
            this.failure = new FailureBuilder(failure);
            this._visitables.get((Object)"failure").add(this.failure);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFailure() {
        return this.failure != null;
    }

    @Override
    public IntegrationStatusFluent.FailureNested<A> withNewFailure() {
        return new FailureNestedImpl();
    }

    @Override
    public IntegrationStatusFluent.FailureNested<A> withNewFailureLike(Failure item) {
        return new FailureNestedImpl(item);
    }

    @Override
    public IntegrationStatusFluent.FailureNested<A> editFailure() {
        return this.withNewFailureLike(this.getFailure());
    }

    @Override
    public IntegrationStatusFluent.FailureNested<A> editOrNewFailure() {
        return this.withNewFailureLike(this.getFailure() != null ? this.getFailure() : new FailureBuilder().build());
    }

    @Override
    public IntegrationStatusFluent.FailureNested<A> editOrNewFailureLike(Failure item) {
        return this.withNewFailureLike(this.getFailure() != null ? this.getFailure() : item);
    }

    @Override
    public A addToGeneratedResources(Integer index, ResourceSpec item) {
        if (this.generatedResources == null) {
            this.generatedResources = new ArrayList<ResourceSpecBuilder>();
        }
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        this._visitables.get((Object)"generatedResources").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"generatedResources").size(), builder);
        this.generatedResources.add(index >= 0 ? index.intValue() : this.generatedResources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToGeneratedResources(Integer index, ResourceSpec item) {
        if (this.generatedResources == null) {
            this.generatedResources = new ArrayList<ResourceSpecBuilder>();
        }
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"generatedResources").size()) {
            this._visitables.get((Object)"generatedResources").add(builder);
        } else {
            this._visitables.get((Object)"generatedResources").set(index, builder);
        }
        if (index < 0 || index >= this.generatedResources.size()) {
            this.generatedResources.add(builder);
        } else {
            this.generatedResources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToGeneratedResources(ResourceSpec ... items) {
        if (this.generatedResources == null) {
            this.generatedResources = new ArrayList<ResourceSpecBuilder>();
        }
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"generatedResources").add(builder);
            this.generatedResources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToGeneratedResources(Collection<ResourceSpec> items) {
        if (this.generatedResources == null) {
            this.generatedResources = new ArrayList<ResourceSpecBuilder>();
        }
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"generatedResources").add(builder);
            this.generatedResources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromGeneratedResources(ResourceSpec ... items) {
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"generatedResources").remove(builder);
            if (this.generatedResources == null) continue;
            this.generatedResources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGeneratedResources(Collection<ResourceSpec> items) {
        for (ResourceSpec item : items) {
            ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
            this._visitables.get((Object)"generatedResources").remove(builder);
            if (this.generatedResources == null) continue;
            this.generatedResources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromGeneratedResources(Predicate<ResourceSpecBuilder> predicate) {
        if (this.generatedResources == null) {
            return (A)this;
        }
        Iterator<ResourceSpecBuilder> each = this.generatedResources.iterator();
        List visitables = this._visitables.get((Object)"generatedResources");
        while (each.hasNext()) {
            ResourceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResourceSpec> getGeneratedResources() {
        return IntegrationStatusFluentImpl.build(this.generatedResources);
    }

    @Override
    public List<ResourceSpec> buildGeneratedResources() {
        return IntegrationStatusFluentImpl.build(this.generatedResources);
    }

    @Override
    public ResourceSpec buildGeneratedResource(Integer index) {
        return this.generatedResources.get(index).build();
    }

    @Override
    public ResourceSpec buildFirstGeneratedResource() {
        return this.generatedResources.get(0).build();
    }

    @Override
    public ResourceSpec buildLastGeneratedResource() {
        return this.generatedResources.get(this.generatedResources.size() - 1).build();
    }

    @Override
    public ResourceSpec buildMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item : this.generatedResources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item : this.generatedResources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGeneratedResources(List<ResourceSpec> generatedResources) {
        if (this.generatedResources != null) {
            this._visitables.get((Object)"generatedResources").removeAll(this.generatedResources);
        }
        if (generatedResources != null) {
            this.generatedResources = new ArrayList<ResourceSpecBuilder>();
            for (ResourceSpec item : generatedResources) {
                this.addToGeneratedResources(item);
            }
        } else {
            this.generatedResources = null;
        }
        return (A)this;
    }

    @Override
    public A withGeneratedResources(ResourceSpec ... generatedResources) {
        if (this.generatedResources != null) {
            this.generatedResources.clear();
        }
        if (generatedResources != null) {
            for (ResourceSpec item : generatedResources) {
                this.addToGeneratedResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGeneratedResources() {
        return this.generatedResources != null && !this.generatedResources.isEmpty();
    }

    @Override
    public IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResource() {
        return new GeneratedResourcesNestedImpl();
    }

    @Override
    public IntegrationStatusFluent.GeneratedResourcesNested<A> addNewGeneratedResourceLike(ResourceSpec item) {
        return new GeneratedResourcesNestedImpl(-1, item);
    }

    @Override
    public IntegrationStatusFluent.GeneratedResourcesNested<A> setNewGeneratedResourceLike(Integer index, ResourceSpec item) {
        return new GeneratedResourcesNestedImpl(index, item);
    }

    @Override
    public IntegrationStatusFluent.GeneratedResourcesNested<A> editGeneratedResource(Integer index) {
        if (this.generatedResources.size() <= index) {
            throw new RuntimeException("Can't edit generatedResources. Index exceeds size.");
        }
        return this.setNewGeneratedResourceLike(index, this.buildGeneratedResource(index));
    }

    @Override
    public IntegrationStatusFluent.GeneratedResourcesNested<A> editFirstGeneratedResource() {
        if (this.generatedResources.size() == 0) {
            throw new RuntimeException("Can't edit first generatedResources. The list is empty.");
        }
        return this.setNewGeneratedResourceLike(0, this.buildGeneratedResource(0));
    }

    @Override
    public IntegrationStatusFluent.GeneratedResourcesNested<A> editLastGeneratedResource() {
        int index = this.generatedResources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last generatedResources. The list is empty.");
        }
        return this.setNewGeneratedResourceLike(index, this.buildGeneratedResource(index));
    }

    @Override
    public IntegrationStatusFluent.GeneratedResourcesNested<A> editMatchingGeneratedResource(Predicate<ResourceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.generatedResources.size(); ++i) {
            if (!predicate.test(this.generatedResources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching generatedResources. No match found.");
        }
        return this.setNewGeneratedResourceLike(index, this.buildGeneratedResource(index));
    }

    @Override
    public A addToGeneratedSources(Integer index, SourceSpec item) {
        if (this.generatedSources == null) {
            this.generatedSources = new ArrayList<SourceSpecBuilder>();
        }
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        this._visitables.get((Object)"generatedSources").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"generatedSources").size(), builder);
        this.generatedSources.add(index >= 0 ? index.intValue() : this.generatedSources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToGeneratedSources(Integer index, SourceSpec item) {
        if (this.generatedSources == null) {
            this.generatedSources = new ArrayList<SourceSpecBuilder>();
        }
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"generatedSources").size()) {
            this._visitables.get((Object)"generatedSources").add(builder);
        } else {
            this._visitables.get((Object)"generatedSources").set(index, builder);
        }
        if (index < 0 || index >= this.generatedSources.size()) {
            this.generatedSources.add(builder);
        } else {
            this.generatedSources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToGeneratedSources(SourceSpec ... items) {
        if (this.generatedSources == null) {
            this.generatedSources = new ArrayList<SourceSpecBuilder>();
        }
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"generatedSources").add(builder);
            this.generatedSources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToGeneratedSources(Collection<SourceSpec> items) {
        if (this.generatedSources == null) {
            this.generatedSources = new ArrayList<SourceSpecBuilder>();
        }
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"generatedSources").add(builder);
            this.generatedSources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromGeneratedSources(SourceSpec ... items) {
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"generatedSources").remove(builder);
            if (this.generatedSources == null) continue;
            this.generatedSources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGeneratedSources(Collection<SourceSpec> items) {
        for (SourceSpec item : items) {
            SourceSpecBuilder builder = new SourceSpecBuilder(item);
            this._visitables.get((Object)"generatedSources").remove(builder);
            if (this.generatedSources == null) continue;
            this.generatedSources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromGeneratedSources(Predicate<SourceSpecBuilder> predicate) {
        if (this.generatedSources == null) {
            return (A)this;
        }
        Iterator<SourceSpecBuilder> each = this.generatedSources.iterator();
        List visitables = this._visitables.get((Object)"generatedSources");
        while (each.hasNext()) {
            SourceSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SourceSpec> getGeneratedSources() {
        return IntegrationStatusFluentImpl.build(this.generatedSources);
    }

    @Override
    public List<SourceSpec> buildGeneratedSources() {
        return IntegrationStatusFluentImpl.build(this.generatedSources);
    }

    @Override
    public SourceSpec buildGeneratedSource(Integer index) {
        return this.generatedSources.get(index).build();
    }

    @Override
    public SourceSpec buildFirstGeneratedSource() {
        return this.generatedSources.get(0).build();
    }

    @Override
    public SourceSpec buildLastGeneratedSource() {
        return this.generatedSources.get(this.generatedSources.size() - 1).build();
    }

    @Override
    public SourceSpec buildMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item : this.generatedSources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item : this.generatedSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGeneratedSources(List<SourceSpec> generatedSources) {
        if (this.generatedSources != null) {
            this._visitables.get((Object)"generatedSources").removeAll(this.generatedSources);
        }
        if (generatedSources != null) {
            this.generatedSources = new ArrayList<SourceSpecBuilder>();
            for (SourceSpec item : generatedSources) {
                this.addToGeneratedSources(item);
            }
        } else {
            this.generatedSources = null;
        }
        return (A)this;
    }

    @Override
    public A withGeneratedSources(SourceSpec ... generatedSources) {
        if (this.generatedSources != null) {
            this.generatedSources.clear();
        }
        if (generatedSources != null) {
            for (SourceSpec item : generatedSources) {
                this.addToGeneratedSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGeneratedSources() {
        return this.generatedSources != null && !this.generatedSources.isEmpty();
    }

    @Override
    public IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSource() {
        return new GeneratedSourcesNestedImpl();
    }

    @Override
    public IntegrationStatusFluent.GeneratedSourcesNested<A> addNewGeneratedSourceLike(SourceSpec item) {
        return new GeneratedSourcesNestedImpl(-1, item);
    }

    @Override
    public IntegrationStatusFluent.GeneratedSourcesNested<A> setNewGeneratedSourceLike(Integer index, SourceSpec item) {
        return new GeneratedSourcesNestedImpl(index, item);
    }

    @Override
    public IntegrationStatusFluent.GeneratedSourcesNested<A> editGeneratedSource(Integer index) {
        if (this.generatedSources.size() <= index) {
            throw new RuntimeException("Can't edit generatedSources. Index exceeds size.");
        }
        return this.setNewGeneratedSourceLike(index, this.buildGeneratedSource(index));
    }

    @Override
    public IntegrationStatusFluent.GeneratedSourcesNested<A> editFirstGeneratedSource() {
        if (this.generatedSources.size() == 0) {
            throw new RuntimeException("Can't edit first generatedSources. The list is empty.");
        }
        return this.setNewGeneratedSourceLike(0, this.buildGeneratedSource(0));
    }

    @Override
    public IntegrationStatusFluent.GeneratedSourcesNested<A> editLastGeneratedSource() {
        int index = this.generatedSources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last generatedSources. The list is empty.");
        }
        return this.setNewGeneratedSourceLike(index, this.buildGeneratedSource(index));
    }

    @Override
    public IntegrationStatusFluent.GeneratedSourcesNested<A> editMatchingGeneratedSource(Predicate<SourceSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.generatedSources.size(); ++i) {
            if (!predicate.test(this.generatedSources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching generatedSources. No match found.");
        }
        return this.setNewGeneratedSourceLike(index, this.buildGeneratedSource(index));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    @Deprecated
    public A withNewImage(String arg0) {
        return this.withImage(new String(arg0));
    }

    @Override
    public String getKit() {
        return this.kit;
    }

    @Override
    public A withKit(String kit) {
        this.kit = kit;
        return (A)this;
    }

    @Override
    public Boolean hasKit() {
        return this.kit != null;
    }

    @Override
    @Deprecated
    public A withNewKit(String arg0) {
        return this.withKit(new String(arg0));
    }

    @Override
    public String getLastInitTimestamp() {
        return this.lastInitTimestamp;
    }

    @Override
    public A withLastInitTimestamp(String lastInitTimestamp) {
        this.lastInitTimestamp = lastInitTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasLastInitTimestamp() {
        return this.lastInitTimestamp != null;
    }

    @Override
    @Deprecated
    public A withNewLastInitTimestamp(String arg0) {
        return this.withLastInitTimestamp(new String(arg0));
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    @Deprecated
    public A withNewPhase(String arg0) {
        return this.withPhase(new String(arg0));
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    @Deprecated
    public A withNewPlatform(String arg0) {
        return this.withPlatform(new String(arg0));
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    @Override
    public Boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    @Deprecated
    public A withNewProfile(String arg0) {
        return this.withProfile(new String(arg0));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    @Override
    public A withRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    @Override
    @Deprecated
    public A withNewRuntimeProvider(String arg0) {
        return this.withRuntimeProvider(new String(arg0));
    }

    @Override
    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    @Override
    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    @Override
    @Deprecated
    public A withNewRuntimeVersion(String arg0) {
        return this.withRuntimeVersion(new String(arg0));
    }

    @Override
    public String getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(String selector) {
        this.selector = selector;
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    @Deprecated
    public A withNewSelector(String arg0) {
        return this.withSelector(new String(arg0));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    @Deprecated
    public A withNewVersion(String arg0) {
        return this.withVersion(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationStatusFluentImpl that = (IntegrationStatusFluentImpl)o;
        if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) {
            return false;
        }
        if (this.digest != null ? !this.digest.equals(that.digest) : that.digest != null) {
            return false;
        }
        if (this.failure != null ? !this.failure.equals(that.failure) : that.failure != null) {
            return false;
        }
        if (this.generatedResources != null ? !this.generatedResources.equals(that.generatedResources) : that.generatedResources != null) {
            return false;
        }
        if (this.generatedSources != null ? !this.generatedSources.equals(that.generatedSources) : that.generatedSources != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.kit != null ? !this.kit.equals(that.kit) : that.kit != null) {
            return false;
        }
        if (this.lastInitTimestamp != null ? !this.lastInitTimestamp.equals(that.lastInitTimestamp) : that.lastInitTimestamp != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.runtimeProvider != null ? !this.runtimeProvider.equals(that.runtimeProvider) : that.runtimeProvider != null) {
            return false;
        }
        if (this.runtimeVersion != null ? !this.runtimeVersion.equals(that.runtimeVersion) : that.runtimeVersion != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return Objects.hash(this.capabilities, this.conditions, this.configuration, this.dependencies, this.digest, this.failure, this.generatedResources, this.generatedSources, this.image, this.kit, this.lastInitTimestamp, this.phase, this.platform, this.profile, this.replicas, this.runtimeProvider, this.runtimeVersion, this.selector, this.version, super.hashCode());
    }

    public class GeneratedSourcesNestedImpl<N>
    extends SourceSpecFluentImpl<IntegrationStatusFluent.GeneratedSourcesNested<N>>
    implements IntegrationStatusFluent.GeneratedSourcesNested<N>,
    Nested<N> {
        SourceSpecBuilder builder;
        Integer index;

        GeneratedSourcesNestedImpl(Integer index, SourceSpec item) {
            this.index = index;
            this.builder = new SourceSpecBuilder(this, item);
        }

        GeneratedSourcesNestedImpl() {
            this.index = -1;
            this.builder = new SourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationStatusFluentImpl.this.setToGeneratedSources(this.index, this.builder.build());
        }

        @Override
        public N endGeneratedSource() {
            return this.and();
        }
    }

    public class GeneratedResourcesNestedImpl<N>
    extends ResourceSpecFluentImpl<IntegrationStatusFluent.GeneratedResourcesNested<N>>
    implements IntegrationStatusFluent.GeneratedResourcesNested<N>,
    Nested<N> {
        ResourceSpecBuilder builder;
        Integer index;

        GeneratedResourcesNestedImpl(Integer index, ResourceSpec item) {
            this.index = index;
            this.builder = new ResourceSpecBuilder(this, item);
        }

        GeneratedResourcesNestedImpl() {
            this.index = -1;
            this.builder = new ResourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationStatusFluentImpl.this.setToGeneratedResources(this.index, this.builder.build());
        }

        @Override
        public N endGeneratedResource() {
            return this.and();
        }
    }

    public class FailureNestedImpl<N>
    extends FailureFluentImpl<IntegrationStatusFluent.FailureNested<N>>
    implements IntegrationStatusFluent.FailureNested<N>,
    Nested<N> {
        FailureBuilder builder;

        FailureNestedImpl(Failure item) {
            this.builder = new FailureBuilder(this, item);
        }

        FailureNestedImpl() {
            this.builder = new FailureBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationStatusFluentImpl.this.withFailure(this.builder.build());
        }

        @Override
        public N endFailure() {
            return this.and();
        }
    }

    public class ConfigurationNestedImpl<N>
    extends ConfigurationSpecFluentImpl<IntegrationStatusFluent.ConfigurationNested<N>>
    implements IntegrationStatusFluent.ConfigurationNested<N>,
    Nested<N> {
        ConfigurationSpecBuilder builder;
        Integer index;

        ConfigurationNestedImpl(Integer index, ConfigurationSpec item) {
            this.index = index;
            this.builder = new ConfigurationSpecBuilder(this, item);
        }

        ConfigurationNestedImpl() {
            this.index = -1;
            this.builder = new ConfigurationSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationStatusFluentImpl.this.setToConfiguration(this.index, this.builder.build());
        }

        @Override
        public N endConfiguration() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends IntegrationConditionFluentImpl<IntegrationStatusFluent.ConditionsNested<N>>
    implements IntegrationStatusFluent.ConditionsNested<N>,
    Nested<N> {
        IntegrationConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, IntegrationCondition item) {
            this.index = index;
            this.builder = new IntegrationConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new IntegrationConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

