/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.ConfigurationSpec;
import io.fabric8.camelk.v1.ConfigurationSpecBuilder;
import io.fabric8.camelk.v1.ConfigurationSpecFluentImpl;
import io.fabric8.camelk.v1.IntegrationKitSpec;
import io.fabric8.camelk.v1.IntegrationKitSpecFluent;
import io.fabric8.camelk.v1.TraitSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IntegrationKitSpecFluentImpl<A extends IntegrationKitSpecFluent<A>>
extends BaseFluent<A>
implements IntegrationKitSpecFluent<A> {
    private List<ConfigurationSpecBuilder> configuration;
    private List<String> dependencies;
    private String image;
    private String profile;
    private List<String> repositories;
    private Map<String, TraitSpec> traits;

    public IntegrationKitSpecFluentImpl() {
    }

    public IntegrationKitSpecFluentImpl(IntegrationKitSpec instance) {
        this.withConfiguration(instance.getConfiguration());
        this.withDependencies(instance.getDependencies());
        this.withImage(instance.getImage());
        this.withProfile(instance.getProfile());
        this.withRepositories(instance.getRepositories());
        this.withTraits(instance.getTraits());
    }

    @Override
    public A addToConfiguration(int index, ConfigurationSpec item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
        }
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        this._visitables.get((Object)"configuration").add(index >= 0 ? index : this._visitables.get((Object)"configuration").size(), builder);
        this.configuration.add(index >= 0 ? index : this.configuration.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConfiguration(int index, ConfigurationSpec item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
        }
        ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"configuration").size()) {
            this._visitables.get((Object)"configuration").add(builder);
        } else {
            this._visitables.get((Object)"configuration").set(index, builder);
        }
        if (index < 0 || index >= this.configuration.size()) {
            this.configuration.add(builder);
        } else {
            this.configuration.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConfiguration(ConfigurationSpec ... items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
        }
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfiguration(Collection<ConfigurationSpec> items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
        }
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfiguration(ConfigurationSpec ... items) {
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").remove(builder);
            if (this.configuration == null) continue;
            this.configuration.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfiguration(Collection<ConfigurationSpec> items) {
        for (ConfigurationSpec item : items) {
            ConfigurationSpecBuilder builder = new ConfigurationSpecBuilder(item);
            this._visitables.get((Object)"configuration").remove(builder);
            if (this.configuration == null) continue;
            this.configuration.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        if (this.configuration == null) {
            return (A)this;
        }
        Iterator<ConfigurationSpecBuilder> each = this.configuration.iterator();
        List visitables = this._visitables.get((Object)"configuration");
        while (each.hasNext()) {
            ConfigurationSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ConfigurationSpec> getConfiguration() {
        return IntegrationKitSpecFluentImpl.build(this.configuration);
    }

    @Override
    public List<ConfigurationSpec> buildConfiguration() {
        return IntegrationKitSpecFluentImpl.build(this.configuration);
    }

    @Override
    public ConfigurationSpec buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    @Override
    public ConfigurationSpec buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    @Override
    public ConfigurationSpec buildLastConfiguration() {
        return this.configuration.get(this.configuration.size() - 1).build();
    }

    @Override
    public ConfigurationSpec buildMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        for (ConfigurationSpecBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConfiguration(List<ConfigurationSpec> configuration) {
        if (this.configuration != null) {
            this._visitables.get((Object)"configuration").removeAll(this.configuration);
        }
        if (configuration != null) {
            this.configuration = new ArrayList<ConfigurationSpecBuilder>();
            for (ConfigurationSpec item : configuration) {
                this.addToConfiguration(item);
            }
        } else {
            this.configuration = null;
        }
        return (A)this;
    }

    @Override
    public A withConfiguration(ConfigurationSpec ... configuration) {
        if (this.configuration != null) {
            this.configuration.clear();
        }
        if (configuration != null) {
            for (ConfigurationSpec item : configuration) {
                this.addToConfiguration(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfiguration() {
        return this.configuration != null && !this.configuration.isEmpty();
    }

    @Override
    public A addNewConfiguration(String type, String value) {
        return this.addToConfiguration(new ConfigurationSpec(type, value));
    }

    @Override
    public IntegrationKitSpecFluent.ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    @Override
    public IntegrationKitSpecFluent.ConfigurationNested<A> addNewConfigurationLike(ConfigurationSpec item) {
        return new ConfigurationNestedImpl(-1, item);
    }

    @Override
    public IntegrationKitSpecFluent.ConfigurationNested<A> setNewConfigurationLike(int index, ConfigurationSpec item) {
        return new ConfigurationNestedImpl(index, item);
    }

    @Override
    public IntegrationKitSpecFluent.ConfigurationNested<A> editConfiguration(int index) {
        if (this.configuration.size() <= index) {
            throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    @Override
    public IntegrationKitSpecFluent.ConfigurationNested<A> editFirstConfiguration() {
        if (this.configuration.size() == 0) {
            throw new RuntimeException("Can't edit first configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(0, this.buildConfiguration(0));
    }

    @Override
    public IntegrationKitSpecFluent.ConfigurationNested<A> editLastConfiguration() {
        int index = this.configuration.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    @Override
    public IntegrationKitSpecFluent.ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configuration.size(); ++i) {
            if (!predicate.test(this.configuration.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configuration. No match found.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    @Override
    public A addToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDependencies(String ... items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDependencies(Collection<String> items) {
        for (String item : items) {
            if (this.dependencies == null) continue;
            this.dependencies.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    @Override
    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    @Override
    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    @Override
    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDependencies(List<String> dependencies) {
        if (this.dependencies != null) {
            this._visitables.get((Object)"dependencies").removeAll(this.dependencies);
        }
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)this;
    }

    @Override
    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    @Override
    public A addNewDependency(StringBuilder arg1) {
        return this.addToDependencies(new String(arg1));
    }

    @Override
    public A addNewDependency(int[] arg1, int arg2, int arg3) {
        return this.addToDependencies(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewDependency(char[] arg1) {
        return this.addToDependencies(new String(arg1));
    }

    @Override
    public A addNewDependency(StringBuffer arg1) {
        return this.addToDependencies(new String(arg1));
    }

    @Override
    public A addNewDependency(byte[] arg1, int arg2) {
        return this.addToDependencies(new String(arg1, arg2));
    }

    @Override
    public A addNewDependency(byte[] arg1) {
        return this.addToDependencies(new String(arg1));
    }

    @Override
    public A addNewDependency(char[] arg1, int arg2, int arg3) {
        return this.addToDependencies(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewDependency(byte[] arg1, int arg2, int arg3) {
        return this.addToDependencies(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewDependency(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToDependencies(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewDependency(String arg1) {
        return this.addToDependencies(new String(arg1));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(int[] arg1, int arg2, int arg3) {
        return this.withImage(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewImage(char[] arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(byte[] arg1, int arg2) {
        return this.withImage(new String(arg1, arg2));
    }

    @Override
    public A withNewImage(byte[] arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(char[] arg1, int arg2, int arg3) {
        return this.withImage(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewImage(byte[] arg1, int arg2, int arg3) {
        return this.withImage(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewImage(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withImage(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    @Override
    public Boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public A withNewProfile(StringBuilder arg1) {
        return this.withProfile(new String(arg1));
    }

    @Override
    public A withNewProfile(int[] arg1, int arg2, int arg3) {
        return this.withProfile(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewProfile(char[] arg1) {
        return this.withProfile(new String(arg1));
    }

    @Override
    public A withNewProfile(StringBuffer arg1) {
        return this.withProfile(new String(arg1));
    }

    @Override
    public A withNewProfile(byte[] arg1, int arg2) {
        return this.withProfile(new String(arg1, arg2));
    }

    @Override
    public A withNewProfile(byte[] arg1) {
        return this.withProfile(new String(arg1));
    }

    @Override
    public A withNewProfile(char[] arg1, int arg2, int arg3) {
        return this.withProfile(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewProfile(byte[] arg1, int arg2, int arg3) {
        return this.withProfile(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewProfile(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withProfile(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewProfile(String arg1) {
        return this.withProfile(new String(arg1));
    }

    @Override
    public A addToRepositories(int index, String item) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        this.repositories.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRepositories(int index, String item) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        this.repositories.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRepositories(String ... items) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        for (String item : items) {
            this.repositories.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRepositories(Collection<String> items) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        for (String item : items) {
            this.repositories.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRepositories(String ... items) {
        for (String item : items) {
            if (this.repositories == null) continue;
            this.repositories.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRepositories(Collection<String> items) {
        for (String item : items) {
            if (this.repositories == null) continue;
            this.repositories.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRepositories() {
        return this.repositories;
    }

    @Override
    public String getRepository(int index) {
        return this.repositories.get(index);
    }

    @Override
    public String getFirstRepository() {
        return this.repositories.get(0);
    }

    @Override
    public String getLastRepository() {
        return this.repositories.get(this.repositories.size() - 1);
    }

    @Override
    public String getMatchingRepository(Predicate<String> predicate) {
        for (String item : this.repositories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRepository(Predicate<String> predicate) {
        for (String item : this.repositories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRepositories(List<String> repositories) {
        if (this.repositories != null) {
            this._visitables.get((Object)"repositories").removeAll(this.repositories);
        }
        if (repositories != null) {
            this.repositories = new ArrayList<String>();
            for (String item : repositories) {
                this.addToRepositories(item);
            }
        } else {
            this.repositories = null;
        }
        return (A)this;
    }

    @Override
    public A withRepositories(String ... repositories) {
        if (this.repositories != null) {
            this.repositories.clear();
        }
        if (repositories != null) {
            for (String item : repositories) {
                this.addToRepositories(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepositories() {
        return this.repositories != null && !this.repositories.isEmpty();
    }

    @Override
    public A addNewRepository(StringBuilder arg1) {
        return this.addToRepositories(new String(arg1));
    }

    @Override
    public A addNewRepository(int[] arg1, int arg2, int arg3) {
        return this.addToRepositories(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewRepository(char[] arg1) {
        return this.addToRepositories(new String(arg1));
    }

    @Override
    public A addNewRepository(StringBuffer arg1) {
        return this.addToRepositories(new String(arg1));
    }

    @Override
    public A addNewRepository(byte[] arg1, int arg2) {
        return this.addToRepositories(new String(arg1, arg2));
    }

    @Override
    public A addNewRepository(byte[] arg1) {
        return this.addToRepositories(new String(arg1));
    }

    @Override
    public A addNewRepository(char[] arg1, int arg2, int arg3) {
        return this.addToRepositories(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewRepository(byte[] arg1, int arg2, int arg3) {
        return this.addToRepositories(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewRepository(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToRepositories(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewRepository(String arg1) {
        return this.addToRepositories(new String(arg1));
    }

    @Override
    public A addToTraits(String key, TraitSpec value) {
        if (this.traits == null && key != null && value != null) {
            this.traits = new LinkedHashMap<String, TraitSpec>();
        }
        if (key != null && value != null) {
            this.traits.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToTraits(Map<String, TraitSpec> map) {
        if (this.traits == null && map != null) {
            this.traits = new LinkedHashMap<String, TraitSpec>();
        }
        if (map != null) {
            this.traits.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromTraits(String key) {
        if (this.traits == null) {
            return (A)this;
        }
        if (key != null && this.traits != null) {
            this.traits.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromTraits(Map<String, TraitSpec> map) {
        if (this.traits == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.traits == null) continue;
                this.traits.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, TraitSpec> getTraits() {
        return this.traits;
    }

    @Override
    public <K, V> A withTraits(Map<String, TraitSpec> traits) {
        this.traits = traits == null ? null : new LinkedHashMap<String, TraitSpec>(traits);
        return (A)this;
    }

    @Override
    public Boolean hasTraits() {
        return this.traits != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationKitSpecFluentImpl that = (IntegrationKitSpecFluentImpl)o;
        if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) {
            return false;
        }
        if (this.repositories != null ? !this.repositories.equals(that.repositories) : that.repositories != null) {
            return false;
        }
        return !(this.traits != null ? !this.traits.equals(that.traits) : that.traits != null);
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.dependencies, this.image, this.profile, this.repositories, this.traits, super.hashCode());
    }

    public class ConfigurationNestedImpl<N>
    extends ConfigurationSpecFluentImpl<IntegrationKitSpecFluent.ConfigurationNested<N>>
    implements IntegrationKitSpecFluent.ConfigurationNested<N>,
    Nested<N> {
        private final ConfigurationSpecBuilder builder;
        private final int index;

        ConfigurationNestedImpl(int index, ConfigurationSpec item) {
            this.index = index;
            this.builder = new ConfigurationSpecBuilder(this, item);
        }

        ConfigurationNestedImpl() {
            this.index = -1;
            this.builder = new ConfigurationSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IntegrationKitSpecFluentImpl.this.setToConfiguration(this.index, this.builder.build());
        }

        @Override
        public N endConfiguration() {
            return this.and();
        }
    }
}

