package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class KameletStatusFluentImpl<A extends KameletStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KameletStatusFluent<A> {

    private List<KameletConditionBuilder> conditions;
    private String phase;
    private List<KameletPropertyBuilder> properties;

    public KameletStatusFluentImpl() {
    }

    public KameletStatusFluentImpl(KameletStatus instance) {
        this.withConditions(instance.getConditions()); 
        this.withPhase(instance.getPhase()); 
        this.withProperties(instance.getProperties()); 
    }

    public A addToConditions(int index,KameletCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<KameletConditionBuilder>();}
        KameletConditionBuilder builder = new KameletConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,KameletCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<KameletConditionBuilder>();}
        KameletConditionBuilder builder = new KameletConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(KameletCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<KameletConditionBuilder>();}
        for (KameletCondition item : items) {KameletConditionBuilder builder = new KameletConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<KameletCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<KameletConditionBuilder>();}
        for (KameletCondition item : items) {KameletConditionBuilder builder = new KameletConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(KameletCondition... items) {
        for (KameletCondition item : items) {KameletConditionBuilder builder = new KameletConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<KameletCondition> items) {
        for (KameletCondition item : items) {KameletConditionBuilder builder = new KameletConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<KameletConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<KameletConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          KameletConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<KameletCondition> getConditions() {
        return build(conditions);
    }

    public List<KameletCondition> buildConditions() {
        return build(conditions);
    }

    public KameletCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public KameletCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public KameletCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public KameletCondition buildMatchingCondition(Predicate<KameletConditionBuilder> predicate) {
        for (KameletConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<KameletConditionBuilder> predicate) {
        for (KameletConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<KameletCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<KameletConditionBuilder>(); for (KameletCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(KameletCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (KameletCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.ConditionsNested<A> addNewConditionLike(KameletCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.ConditionsNested<A> setNewConditionLike(int index,KameletCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<KameletConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(int[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(char[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(byte[] arg1,int arg2) {
        return (A)withPhase(new String(arg1, arg2));
    }

    public A withNewPhase(byte[] arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(char[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3) {
        return (A)withPhase(new String(arg1, arg2, arg3));
    }

    public A withNewPhase(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPhase(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A addToProperties(int index,KameletProperty item) {
        if (this.properties == null) {this.properties = new ArrayList<KameletPropertyBuilder>();}
        KameletPropertyBuilder builder = new KameletPropertyBuilder(item);_visitables.get("properties").add(index >= 0 ? index : _visitables.get("properties").size(), builder);this.properties.add(index >= 0 ? index : properties.size(), builder); return (A)this;
    }

    public A setToProperties(int index,KameletProperty item) {
        if (this.properties == null) {this.properties = new ArrayList<KameletPropertyBuilder>();}
        KameletPropertyBuilder builder = new KameletPropertyBuilder(item);
        if (index < 0 || index >= _visitables.get("properties").size()) { _visitables.get("properties").add(builder); } else { _visitables.get("properties").set(index, builder);}
        if (index < 0 || index >= properties.size()) { properties.add(builder); } else { properties.set(index, builder);}
         return (A)this;
    }

    public A addToProperties(KameletProperty... items) {
        if (this.properties == null) {this.properties = new ArrayList<KameletPropertyBuilder>();}
        for (KameletProperty item : items) {KameletPropertyBuilder builder = new KameletPropertyBuilder(item);_visitables.get("properties").add(builder);this.properties.add(builder);} return (A)this;
    }

    public A addAllToProperties(Collection<KameletProperty> items) {
        if (this.properties == null) {this.properties = new ArrayList<KameletPropertyBuilder>();}
        for (KameletProperty item : items) {KameletPropertyBuilder builder = new KameletPropertyBuilder(item);_visitables.get("properties").add(builder);this.properties.add(builder);} return (A)this;
    }

    public A removeFromProperties(KameletProperty... items) {
        for (KameletProperty item : items) {KameletPropertyBuilder builder = new KameletPropertyBuilder(item);_visitables.get("properties").remove(builder);if (this.properties != null) {this.properties.remove(builder);}} return (A)this;
    }

    public A removeAllFromProperties(Collection<KameletProperty> items) {
        for (KameletProperty item : items) {KameletPropertyBuilder builder = new KameletPropertyBuilder(item);_visitables.get("properties").remove(builder);if (this.properties != null) {this.properties.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromProperties(Predicate<KameletPropertyBuilder> predicate) {
        if (properties == null) return (A) this;
        final Iterator<KameletPropertyBuilder> each = properties.iterator();
        final List visitables = _visitables.get("properties");
        while (each.hasNext()) {
          KameletPropertyBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildProperties instead.
 * @return The buildable object.
 */
@Deprecated public List<KameletProperty> getProperties() {
        return build(properties);
    }

    public List<KameletProperty> buildProperties() {
        return build(properties);
    }

    public KameletProperty buildProperty(int index) {
        return this.properties.get(index).build();
    }

    public KameletProperty buildFirstProperty() {
        return this.properties.get(0).build();
    }

    public KameletProperty buildLastProperty() {
        return this.properties.get(properties.size() - 1).build();
    }

    public KameletProperty buildMatchingProperty(Predicate<KameletPropertyBuilder> predicate) {
        for (KameletPropertyBuilder item: properties) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingProperty(Predicate<KameletPropertyBuilder> predicate) {
        for (KameletPropertyBuilder item: properties) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withProperties(List<KameletProperty> properties) {
        if (this.properties != null) { _visitables.get("properties").removeAll(this.properties);}
        if (properties != null) {this.properties = new ArrayList<KameletPropertyBuilder>(); for (KameletProperty item : properties){this.addToProperties(item);}} else { this.properties = null;} return (A) this;
    }

    public A withProperties(KameletProperty... properties) {
        if (this.properties != null) {this.properties.clear();}
        if (properties != null) {for (KameletProperty item :properties){ this.addToProperties(item);}} return (A) this;
    }

    public Boolean hasProperties() {
        return properties != null && !properties.isEmpty();
    }

    public A addNewProperty(String _default,String name) {
        return (A)addToProperties(new KameletProperty(_default, name));
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.PropertiesNested<A> addNewProperty() {
        return new PropertiesNestedImpl();
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.PropertiesNested<A> addNewPropertyLike(KameletProperty item) {
        return new PropertiesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.PropertiesNested<A> setNewPropertyLike(int index,KameletProperty item) {
        return new PropertiesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.PropertiesNested<A> editProperty(int index) {
        if (properties.size() <= index) throw new RuntimeException("Can't edit properties. Index exceeds size.");
        return setNewPropertyLike(index, buildProperty(index));
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.PropertiesNested<A> editFirstProperty() {
        if (properties.size() == 0) throw new RuntimeException("Can't edit first properties. The list is empty.");
        return setNewPropertyLike(0, buildProperty(0));
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.PropertiesNested<A> editLastProperty() {
        int index = properties.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last properties. The list is empty.");
        return setNewPropertyLike(index, buildProperty(index));
    }

    public io.fabric8.camelk.v1alpha1.KameletStatusFluent.PropertiesNested<A> editMatchingProperty(Predicate<KameletPropertyBuilder> predicate) {
        int index = -1;
        for (int i=0;i<properties.size();i++) { 
        if (predicate.test(properties.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching properties. No match found.");
        return setNewPropertyLike(index, buildProperty(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KameletStatusFluentImpl that = (KameletStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  phase,  properties,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends KameletConditionFluentImpl<io.fabric8.camelk.v1alpha1.KameletStatusFluent.ConditionsNested<N>> implements io.fabric8.camelk.v1alpha1.KameletStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KameletConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,KameletCondition item) {
                this.index = index;
                this.builder = new KameletConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new KameletConditionBuilder(this);
                        
            }

            public N and() {
                return (N) KameletStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


    public class PropertiesNestedImpl<N> extends KameletPropertyFluentImpl<io.fabric8.camelk.v1alpha1.KameletStatusFluent.PropertiesNested<N>> implements io.fabric8.camelk.v1alpha1.KameletStatusFluent.PropertiesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KameletPropertyBuilder builder;
        private final int index;

            PropertiesNestedImpl(int index,KameletProperty item) {
                this.index = index;
                this.builder = new KameletPropertyBuilder(this, item);
                        
            }

            PropertiesNestedImpl() {
                this.index = -1;
                this.builder = new KameletPropertyBuilder(this);
                        
            }

            public N and() {
                return (N) KameletStatusFluentImpl.this.setToProperties(index,builder.build());
            }

            public N endProperty() {
                return and();
            }
    }


}
