package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KameletSpecBuilder extends KameletSpecFluentImpl<KameletSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<KameletSpec,KameletSpecBuilder> {

    KameletSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KameletSpecBuilder() {
        this(true);
    }

    public KameletSpecBuilder(Boolean validationEnabled) {
        this(new KameletSpec(), validationEnabled);
    }

    public KameletSpecBuilder(KameletSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KameletSpecBuilder(KameletSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KameletSpec(), validationEnabled);
    }

    public KameletSpecBuilder(KameletSpecFluent<?> fluent,KameletSpec instance) {
        this(fluent, instance, true);
    }

    public KameletSpecBuilder(KameletSpecFluent<?> fluent,KameletSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuthorization(instance.getAuthorization()); 
        fluent.withDefinition(instance.getDefinition()); 
        fluent.withDependencies(instance.getDependencies()); 
        fluent.withFlow(instance.getFlow()); 
        fluent.withSources(instance.getSources()); 
        fluent.withTypes(instance.getTypes()); 
        this.validationEnabled = validationEnabled; 
    }

    public KameletSpecBuilder(KameletSpec instance) {
        this(instance,true);
    }

    public KameletSpecBuilder(KameletSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuthorization(instance.getAuthorization()); 
        this.withDefinition(instance.getDefinition()); 
        this.withDependencies(instance.getDependencies()); 
        this.withFlow(instance.getFlow()); 
        this.withSources(instance.getSources()); 
        this.withTypes(instance.getTypes()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableKameletSpec build() {
        EditableKameletSpec buildable = new EditableKameletSpec(fluent.getAuthorization(),fluent.getDefinition(),fluent.getDependencies(),fluent.getFlow(),fluent.getSources(),fluent.getTypes());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KameletSpecBuilder that = (KameletSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
