package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KameletBindingStatusBuilder extends KameletBindingStatusFluentImpl<KameletBindingStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<KameletBindingStatus,KameletBindingStatusBuilder> {

    KameletBindingStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KameletBindingStatusBuilder() {
        this(true);
    }

    public KameletBindingStatusBuilder(Boolean validationEnabled) {
        this(new KameletBindingStatus(), validationEnabled);
    }

    public KameletBindingStatusBuilder(KameletBindingStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KameletBindingStatusBuilder(KameletBindingStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KameletBindingStatus(), validationEnabled);
    }

    public KameletBindingStatusBuilder(KameletBindingStatusFluent<?> fluent,KameletBindingStatus instance) {
        this(fluent, instance, true);
    }

    public KameletBindingStatusBuilder(KameletBindingStatusFluent<?> fluent,KameletBindingStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withPhase(instance.getPhase()); 
        this.validationEnabled = validationEnabled; 
    }

    public KameletBindingStatusBuilder(KameletBindingStatus instance) {
        this(instance,true);
    }

    public KameletBindingStatusBuilder(KameletBindingStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withPhase(instance.getPhase()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableKameletBindingStatus build() {
        EditableKameletBindingStatus buildable = new EditableKameletBindingStatus(fluent.getConditions(),fluent.getPhase());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KameletBindingStatusBuilder that = (KameletBindingStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
