package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KameletBindingSpecBuilder extends KameletBindingSpecFluentImpl<KameletBindingSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<KameletBindingSpec,KameletBindingSpecBuilder> {

    KameletBindingSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KameletBindingSpecBuilder() {
        this(true);
    }

    public KameletBindingSpecBuilder(Boolean validationEnabled) {
        this(new KameletBindingSpec(), validationEnabled);
    }

    public KameletBindingSpecBuilder(KameletBindingSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KameletBindingSpecBuilder(KameletBindingSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KameletBindingSpec(), validationEnabled);
    }

    public KameletBindingSpecBuilder(KameletBindingSpecFluent<?> fluent,KameletBindingSpec instance) {
        this(fluent, instance, true);
    }

    public KameletBindingSpecBuilder(KameletBindingSpecFluent<?> fluent,KameletBindingSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withIntegration(instance.getIntegration()); 
        fluent.withSink(instance.getSink()); 
        fluent.withSource(instance.getSource()); 
        this.validationEnabled = validationEnabled; 
    }

    public KameletBindingSpecBuilder(KameletBindingSpec instance) {
        this(instance,true);
    }

    public KameletBindingSpecBuilder(KameletBindingSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withIntegration(instance.getIntegration()); 
        this.withSink(instance.getSink()); 
        this.withSource(instance.getSource()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableKameletBindingSpec build() {
        EditableKameletBindingSpec buildable = new EditableKameletBindingSpec(fluent.getIntegration(),fluent.getSink(),fluent.getSource());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KameletBindingSpecBuilder that = (KameletBindingSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
