package io.fabric8.camelk.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointPropertiesBuilder extends EndpointPropertiesFluentImpl<EndpointPropertiesBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<EndpointProperties,EndpointPropertiesBuilder> {

    EndpointPropertiesFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointPropertiesBuilder() {
        this(true);
    }

    public EndpointPropertiesBuilder(Boolean validationEnabled) {
        this(new EndpointProperties(), validationEnabled);
    }

    public EndpointPropertiesBuilder(EndpointPropertiesFluent<?> fluent) {
        this(fluent, true);
    }

    public EndpointPropertiesBuilder(EndpointPropertiesFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new EndpointProperties(), validationEnabled);
    }

    public EndpointPropertiesBuilder(EndpointPropertiesFluent<?> fluent,EndpointProperties instance) {
        this(fluent, instance, true);
    }

    public EndpointPropertiesBuilder(EndpointPropertiesFluent<?> fluent,EndpointProperties instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public EndpointPropertiesBuilder(EndpointProperties instance) {
        this(instance,true);
    }

    public EndpointPropertiesBuilder(EndpointProperties instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1alpha1.EditableEndpointProperties build() {
        EditableEndpointProperties buildable = new EditableEndpointProperties();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointPropertiesBuilder that = (EndpointPropertiesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
