package io.fabric8.camelk.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EventTypeSpecFluentImpl<A extends EventTypeSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EventTypeSpecFluent<A> {

    private String mediaType;
    private JSONSchemaProps schema;

    public EventTypeSpecFluentImpl() {
    }

    public EventTypeSpecFluentImpl(EventTypeSpec instance) {
        this.withMediaType(instance.getMediaType()); 
        this.withSchema(instance.getSchema()); 
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public A withMediaType(String mediaType) {
        this.mediaType=mediaType; return (A) this;
    }

    public Boolean hasMediaType() {
        return this.mediaType != null;
    }

    public A withNewMediaType(StringBuilder arg1) {
        return (A)withMediaType(new String(arg1));
    }

    public A withNewMediaType(int[] arg1,int arg2,int arg3) {
        return (A)withMediaType(new String(arg1, arg2, arg3));
    }

    public A withNewMediaType(char[] arg1) {
        return (A)withMediaType(new String(arg1));
    }

    public A withNewMediaType(StringBuffer arg1) {
        return (A)withMediaType(new String(arg1));
    }

    public A withNewMediaType(byte[] arg1,int arg2) {
        return (A)withMediaType(new String(arg1, arg2));
    }

    public A withNewMediaType(byte[] arg1) {
        return (A)withMediaType(new String(arg1));
    }

    public A withNewMediaType(char[] arg1,int arg2,int arg3) {
        return (A)withMediaType(new String(arg1, arg2, arg3));
    }

    public A withNewMediaType(byte[] arg1,int arg2,int arg3) {
        return (A)withMediaType(new String(arg1, arg2, arg3));
    }

    public A withNewMediaType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMediaType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMediaType(String arg1) {
        return (A)withMediaType(new String(arg1));
    }

    public JSONSchemaProps getSchema() {
        return this.schema;
    }

    public A withSchema(JSONSchemaProps schema) {
        this.schema=schema; return (A) this;
    }

    public Boolean hasSchema() {
        return this.schema != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EventTypeSpecFluentImpl that = (EventTypeSpecFluentImpl) o;
        if (mediaType != null ? !mediaType.equals(that.mediaType) :that.mediaType != null) return false;
        if (schema != null ? !schema.equals(that.schema) :that.schema != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(mediaType,  schema,  super.hashCode());
    }

}
